        page    66,80
        TITLE   INSTALL.COM 1.4 Generic Install Utility
;       works with MASM 5.0 and Optasm

COMMENT |

        This program is copyrighted but may be used freely
        for any purpose except military.

 INSTALL  ۲

Install is used in for floppy disk installs.  It ensures the
current drive and directory are set correctly.  Install.com takes
no parameters.

Install.com lives on the floppy disk.  It may be invoked any
number of ways:

e.g.

   A:
   INSTALL
or
   C:
   A:\INSTALL
or
   B:\PROG2\INSTALL.COM
or
   PATH A:\;C:\
   INSTALL

It then sets the current drive and directory to match the drive and
directory where INSTALL.COM itself lives.  It ensures this is a
floppy drive.  If not it aborts with an error message.

If all is well, it uses SET COMSPEC=C:\DOS\COMMAND.COM to invoke
the command processor on the bat file INSTALL2.BAT which lives
in the same drive and directory as INSTALL.COM.

This program is copyrighted but may be used freely for any
purpose except military.  Love Roedy


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com

version 1.4 1998 November 8
- embed Barker address

Version 1.3 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.2 1993 June 9
- embed the new address and phone number

Version 1.1
- allow for possibility of environment string not all upper case.

version 1.0 released to BIX 1991 Nov 30

; |


SAY     MACRO   Msg             ; display message on screen
        LEA     DX,&Msg         ; use LEA rather than
                                ; MOV Offset for more generality
        MOV     AH,09h
        INT     21h
        ENDM

;==============================================================

stack   segment stack           ; keep MS link happy by providing null stack
stack   ends

;==============================================================

CODE    SEGMENT PARA            ; start off in code.

;==============================================================

data    segment byte            ; provide a separate DATA segment
                                ; actually all come after the code

FirstData       Label   Word

;==============================================================
;  V A R I A B L E S

DummyFCB        db      0, 11 dup(" ")


ChildTail               db      25,'/E:2048 /C .\INSTALL2.BAT',0dh
                                ; build command tail here, with length
                                ; byte and trailing Cr, not included in
                                ; length
                                ; We use .\ to stop path searching in
                                ; case INSTALL2.BAT is not in the current
                                ; directory and drive

ParmBlock       label   Word    ; communication region with child
EnvSeg          DW      0       ; address of child's environment region
                                ; leave zero so child sees our ENV.
                                ; Note 0 offset presumed.
TailOff         DW      0       ; Address of child's command line
Tailseg         DW      0
FCB1Off         DW      0       ; address of child's first FCB
FCB1Seg         DW      0
FCB2Off         DW      0       ; address of child's second FCB
FCB2Seg         DW      0


CHILDName       DB      64 dup (0)
                                ; e.g. "C:\DOS\COMMAND.COM",0
                                ; must be fully qualified or in the current dir.
                                ; will not search the path.
                                ; must have explicit .COM or .EXE,
                                ; no .BAT, no leaving extension off.

COMSPEC         DB      'COMSPEC'
                                ; what to look for in the SET environment

BaseDrive       DB      'A'     ; drive where INSTALL.COM lines

Basedir         DB      64 dup (0)
                                ; directory where install.com lives

;==============================================================
;  C O N S T A N T S

;               AsciiZ constants

SPACES          DB      "  ",0
CrLf            DB      13,10,0


;==============================================================
; M E S S A G E S

BannerMsg       label   byte
        DB      13,10
        DB      ' INSTALL 1.4 ۲  Generic Install',13d,10d
        DB      13,10
        DB      'Copyright (c) 1991-1999 Roedy Green Canadian Mind Products.',13,10
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.',13,10,13,10
        db      '$'

NotFloppyMsg    db  13,10
                db 'You must run INSTALL from the A: or B: floppy disk.',13,10
                db 'e.g. A:\INSTALL',13,10
                db '$'

NoRamMsg        db 13,10
                db 'Not enough RAM to run INSTALL2.BAT.  Try removing TSRs or rebooting.',13,10
                db '$'

ChildFailMsg    db 13,10
                db 'INSTALL2.BAT failed. Why?',13,10
                db 'Possibly insufficient RAM, missing INSTALL2.BAT, bad COMSPEC.',13,10
                db '$'

LastData        Label   Word
data            ends

;==============================================================

com     group   code,data       ; force data segment to go at the end!

        ASSUME  CS:com,DS:com,ES:com,SS:com
                                ; seg regs cover everything
        ORG     100H            ; in Code segment

;==============================================================

Start   proc    far
;       Mainline procedure

;=============================
FirstCode       Label   Word

; P R E P A R A T I O N

        Call    Init            ; initialize command blocks
        Say     BannerMsg       ; display the copyright banner
        Call    SetCurDir       ; make current drive/dir match INSTALL.COM
        Call    FloppyOnly      ; Don't continue unless current drive
                                ; is a floppy.  (Might remove this code
                                ; if you want to allow install from disk.)
        Call    GetComspec      ; find COMSPEC=C:\DOS\COMMAND.COM
RamNeeded = 100h+1024+(LastCode-FirstCode)+(LastData-FirstData)
ParasNeeded = (RamNeeded+15)/16 ; calculation done at assembly time
                                ; allow 100h PSP, and 1024 byte stack
                                ; rounded up to paragraphs
        mov     BX,ParasNeeded
        Call    ResizeRam       ; free up ram for use by Child

; S P A W N   T H E  C H I L D
        LEA     DX,ChildName    ; executable
        LEA     BX,ParmBlock    ; pointers to FCBS and ENV
        MOV     AX,4B00h        ; load and execute child process
        INT     21h
        JC      ChildFail       ; probably no such program on path
                                ; or not enough ram.
        Call    CheckRetCode    ; check return code
        jnz     ChildFail

        MOV     AX,4C00H        ; EXIT with return code 0
        INT     21H

;=============================

; E R R O R S

NoRam:
        Say     NoRamMsg                ; not enough RAM for us.
        jmp     Abort

ChildFail:
        Say     ChildFailMsg            ; COMMAND.COM failed
        jmp     Abort

NotFloppy:
        Say     NotFloppyMsg            ; not running on floppy
        jmp     Abort

Abort:
        MOV     AX,4C04H        ; ABORT
        INT     21H

;=============================

SetCurDir       Proc    near

;       Past the end of the environment is:
;       two nulls, then two words of gibberish then:
;       A:\MYSUB\INSTALL.COM then another null
;       Might have lower case chars.
;
;       A: will become our current drive
;       \MYSUB will become our current directory
;       (ASCIIZ string)

        ASSUME  DS:nothing,ES:nothing
        push    DS
        push    ES
        mov     ax,ds:word ptr[02Ch]
        mov     DS,ax
        mov     ES,ax                   ; ES:di points to environment
        sub     di,di
        sub     ax,ax                   ; search for double null
        mov     cx,32768
KeepLooking:
        repne   scasb
                                        ; found single null
        scasb                           ; look one further
        jne     KeepLooking
                                        ; di points just after the
                                        ; double null
        add     di,2                    ; bypass the gibberish
        mov     si,di                   ; mark start of filename
        repne   scasb                   ; search for single null at end
                                        ; of filename
                                        ; di points just past the null
        mov     cx,di
        sub     cx,si                   ; get length of filename proper
        dec     cx                      ; e.g. C:\MySub\INSTALL.COM
                                        ; scan backwards to peel off
                                        ; to just C:\MySub
        sub     di,2                    ; point di to last char of name
        mov     al,'\'
        std
        repne   scasb                   ; search for \
        cld                             ; di points to last char of dir
                                        ; name e.g. C:\Mysub
        inc     di                      ; point to the \
        cmp     cx,2                    ; check for root case C:\
        jg      NotRoot
        inc     di                      ; arrange to plop null PAST the \
NotRoot:
        mov     byte ptr ES:[di],0      ; plop null atop the \
                                        ; now have either C:\0
                                        ; or C:\MySub0
                                        ; with si pointing to first char
                                        ; now ES:si len cx is that string
        push    si
        push    cx
ToUpperCase:
        lodsb
        cmp     al,'a'                  ; make sure string is upper case
        jb      fineAsIs
        cmp     al,'z'
        ja      fineAsIs
        sub     al,'a'-'A'
        mov     byte ptr DS:[si-1],al
FineAsIs:
        loop    ToUpperCase
        pop     cx
        pop     si

;       set new current drive
        mov     ah,0Eh
        mov     dl,DS:[si]              ; drive letter A B etc
        sub     dl,'A'                  ; Drive number (0=A, 1=B, etc.)
        int     21h

;       set new current directory
        mov     dx,si                   ; DS:DX points to asciiz
                                        ; e.g. C:\MySub  no trailing \
        mov     ah,3Bh
        int     21h
        pop     ES
        pop     DS
        ret
        assume  DS:com,ES:com

SetCurDir       EndP

;=============================

FloppyOnly      Proc    Near

;       Ensure the current drive is a floppy.
;       This test is primitive.  There might be F: G: etc floppies too.
;       We only allow A: and B:

        mov     ah,19h
        int     21h             ; get current drive
                                ; AL = Number of default drive (A = 0, B = 1, etc.)
        cmp     al,1
        jbe     IsFloppy
        jmp     NotFloppy

IsFloppy:
        ret

FloppyOnly      EndP

;=============================


GetComspec      Proc    near

;       examine SET COMPSPEC=C:\DOS\COMMAND.COM to get the ChildName,
;       the name of the command processor we have to spawn.

        push    ES
        lea     si,Comspec
        mov     cx,7            ; length of COMSPEC
        call    GetSet          ; find SET COMSPEC=C:\DOS\COMMAND.COM
                                ; ES:di length cx points to C:\DOS\COMMAND.COM
        jcxz    ChildFail
        mov     bx,DS           ; swap DS and ES
        mov     dx,ES
        mov     DS,dx
        mov     ES,bx
        mov     si,di           ; DS:si cx is source
        lea     di,ChildName    ; ES:di is target
        rep     movsb
        mov     ax,0
        stosb                   ; plop a trailing null on
        mov     DS,bx           ; put DS and ES back to normal
        pop     ES
        ret

GetComspec      EndP

;=============================

Init    Proc    Near
;       Init command blocks.  Cannot do this at assembly time as seg unknown.
        LEA     SI,ChildTail
        MOV     TailSeg,DS
        MOV     TailOff,SI

        LEA     SI,DummyFCB
        MOV     FCB1Seg,DS
        MOV     FCB1Off,SI
        MOV     FCB2Seg,DS
        MOV     FCB2Off,SI
        RET
Init    EndP

;=============================

ResizeRam       Proc    Near
;       Spawning must be done into free RAM.  We must give back RAM
;       to the pool.  We presume we are always shrinking.
;       Move stack to new lower place first
;       On entry BX has size of entire region in paragraphs
        mov     ax,bx
        shl     ax,1
        shl     ax,1
        shl     ax,1
        shl     ax,1            ; AX=desired size of region in bytes
        sub     ax,16           ; point SP with 16 byte safety margin just
                                ; under the end of the new region size
        pop     cx              ; preserve our return address, 1 level only
        mov     sp,ax
        push    cx              ; restore our return address
        mov     ah,4aH
        int     21h
        jc      NoRam           ; some trouble with resize
        ret
ResizeRam       EndP

;=============================

CheckRetCode    Proc    Near
; check return code from last spawn
        mov     ah,4Dh
        int     21h
;                               ; ax is the return code
        or      ax,ax
        ret
CheckRetCode    EndP

;=============================

Getset  Proc    near

;       Finds values of variables in the SET environment.
;
;       Let us presume you had put the command:
;       SET  MYVAR=XXXX
;       Into your bat file.  You want to find the current value
;       of MYVAR
;
;       On entry DS:SI CX=len points to a string MYVAR all upper case
;       GetSet will search the environment for that string.
;       On Exit ES:DI CX=len points to the value string XXXX
;       If there is so such string CX will be 0.
;
;       How it works:
;       The segment to the environment is at offset 2Ch in the PSP
;       See Ray Duncan's Advanced MS DOS page 23.
;       The environment has strings of the form YYY=XXXX terminated
;       by a null.  The last string is terminated by two nulls.
;
        push    si                      ; save start of var wanted
        mov     dx,cx                   ; save length of variable wanted
        jcxz    GetSetFail
        mov     ax,ds:word ptr[02Ch]
        mov     ES,ax                   ; ES:di points to environment
        sub     di,di

GetSetLookAgain:
                                        ; DS:si len dx points to var
                                        ;  we are looking for
                                        ; ES:di points to char after null i.e.
                                        ;  the start of new variable,
                                        ;  or to first parm in env,
                                        ;  or to double null in empty env,
                                        ;  or to null, second in terminating pair

        cmp     byte ptr ES:[di],0
        je      GetSetFail              ; we hit double null without finding
                                        ; the variable we wanted.

        mov     bx,di                   ; save start of string
        mov     cx,32768                ; largest possible environment
        mov     al,'='                  ; scan for end of variable
        repne   scasb                   ; terminated by =
        jne     GetSetFail
                                        ; have found =
                                        ; di points just past it
        mov     cx,di
        sub     cx,bx
        dec     cx                      ; cx = len of variable
        cmp     cx,dx                   ; length candidiate variable same
                                        ; as one wanted?
        jne     GetSetBypass            ; no, was not this one
        pop     si
        push    si                      ; DS:si pointer to start of var wanted
        xchg    bx,di                   ; ES:di points to candidate var
                                        ; cx is length, some for both
        repe    cmpsb                   ; has candidate same name?
        mov     di,bx                   ; di points just past equal
        jne     GetSetBypass

GetSetSucceed:
                                        ; we have found the parameter
                                        ; di points just past =
                                        ; at start of value
        mov     bx,di                   ; save start of parm string
        mov     cx,32768                ; string could be very long
        mov     al,0                    ; null terminates string
        repne   scasb
        jne     GetSetFail

                                        ; di points 1 past null
                                        ; ES:bx points to start of value
        mov     cx,di
        sub     cx,bx
        dec     cx                      ; cx = len value
        mov     di,bx                   ; customers want to see start
                                        ; of value
        pop     si                      ; balance the stack
        ret                             ; we are done
;

GetSetBypass:
;                                       ; Variable was not the one
                                        ; wanted, scan over the
                                        ; following value ready to
                                        ; test the nex variable.
                                        ; ES:di point just past the = at end
                                        ; of the candidate variable
        mov     cx,32768                ; max env len
        mov     al,0                    ; search for null
        repne   scasb
        jnz     GetSetFail
                                        ; ES:di now points just past the
                                        ; null at the end of the value
        jmp     GetSetLookAgain

GetSetFail:
        sub     di,di                   ; return dummy ES:0
        mov     cx,di                   ; cx=0
        pop     si                      ; balance the stack
        ret

Getset  EndP
;=============================
LastCode Label  word    ; last byte of RAM
;=============================


;===========================

Start   endp

;==========================
CODE    ends                    ; end of code segment
        end     Start
