#ifndef __VCLSTRM_H
#define __VCLSTRM_H
//
// Copyright (c) 1997 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// Permission to use, redistribute, and copy this file is granted 
// without a fee so long as as the following conditions are adhered to:
//
// o The user assumes all risk for using this software. The authors of this
//   software shall be liable for no damages of any kind.
//
// o If the source code is distributed then this copyright notice must
//   remain unaltered and any modification must be noted.
//

//
//  Title:  VCL Stream <=> C++ I/O Stream Interface
//
//  Description:
//
//    The VclStreamBuffer class allows C++ I/O streams with
//    the VCL TStream class
//
//    Not all I/O stream functionality is implemented at this time.
//
//  Caution:
//
//    The VclStreamBuffer class does not assume ownership of the TStream
//    object is it connected to. The application is responsible for deleting
//    the TStream object.
//
//  How To Use This Class
//
//  void StreamExample (TStream *vclstream)
//  {
//    VclStreamBuffer buffer (vclstream) ;
//    ostream strm (&buffer) ;  // or istream
//
//    strm << "Whatever you want" << endl ;
//


#include <iostream>
#include <classes.hpp>

class VclStreamBuffer : public std::streambuf
{
public:
  VclStreamBuffer (TStream *) ;
  virtual ~VclStreamBuffer () ;
protected:
  virtual int overflow (int cc) ;
  virtual int underflow () ;

  virtual int sync () ;
private:
  char *read_buffer ;
  char *write_buffer ;
  TStream *stream ;
} ;

//
//  Description:
//
//    VCL Input Stream Class
//

class iVclStream : public std::istream
{
public:
  iVclStream (TStream *stream) ;
private:
  VclStreamBuffer stream_buffer ;
} ;

inline iVclStream::iVclStream (TStream *stream) : stream_buffer (stream)
{
  init (&stream_buffer) ;
  return ;
}

//
//  Description:
//
//    VCL Output Stream Class
//

class oVclStream : public std::ostream
{
public:
  oVclStream (TStream *stream) ;
private:
  VclStreamBuffer stream_buffer ;
} ;

inline oVclStream::oVclStream (TStream *stream) : stream_buffer (stream)
{
  init (&stream_buffer) ;
  return ;
}


//
//  Description:
//
//    VCL Input/Output Stream Class
//


class ioVclStream : public std::iostream
{
public:
  ioVclStream (TStream *stream) ;
private:
  VclStreamBuffer stream_buffer ;
} ;

inline ioVclStream::ioVclStream (TStream *stream) : stream_buffer (stream)
{
  init (&stream_buffer) ;
  return ;
}



#endif
