//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "vclbmimage.h"
#include "vclstrm.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)


bool __fastcall TCbBitmapImage::GetEmpty(void)
{
  if (decoded_image.getHeight ()== 0 || decoded_image.getWidth () == 0)
    return true ;
  else
    return false ;
}

int __fastcall TCbBitmapImage::GetHeight(void)
{
  return decoded_image.getHeight () ;
}

int __fastcall TCbBitmapImage::GetWidth(void)
{
  return decoded_image.getWidth () ;
}

void __fastcall TCbBitmapImage::Draw(Graphics::TCanvas* ACanvas, const Windows::TRect &Rect)
{
  if (decoded_image.getWidth () == 0 || decoded_image.getHeight () == 0)
    return ;

  // The largest possible Bitmap Info Header
  BITMAPV4HEADER imageheader ;
  imageheader.bV4Size = sizeof (BITMAPV4HEADER) ;
  imageheader.bV4Width = decoded_image.getWidth () ;
  imageheader.bV4Height = - decoded_image.getHeight () ;
  imageheader.bV4Planes = 1 ;
  imageheader.bV4BitCount = 32 ;
  imageheader.bV4V4Compression = BI_BITFIELDS ;
  imageheader.bV4SizeImage = 0 ;
  imageheader.bV4XPelsPerMeter = 0 ;
  imageheader.bV4YPelsPerMeter = 0 ;
  imageheader.bV4ClrUsed = 0 ;
  imageheader.bV4ClrImportant = 0 ;
  imageheader.bV4BlueMask = 0xFFUL ;
  imageheader.bV4GreenMask = 0xFF00UL ;
  imageheader.bV4RedMask = 0xFF0000UL ;
  imageheader.bV4AlphaMask = 0xFF000000UL ;

  StretchDIBits(ACanvas->Handle,
                Rect.Left, Rect.Top,
                Rect.Right - Rect.Left, Rect.Bottom - Rect.Top,
                0, 0,
                decoded_image.getWidth (), decoded_image.getHeight (),
                &decoded_image [0],
                reinterpret_cast<const BITMAPINFO*>(&imageheader),
                DIB_RGB_COLORS,
                SRCCOPY) ;
  return ;
}

bool __fastcall TCbBitmapImage::Equals(Graphics::TGraphic* Graphic)
{
  TCbBitmapImage *image = dynamic_cast<TCbBitmapImage*>(Graphic) ;
  if (image == 0)
    return false ;

  if (decoded_image.getHeight () != image->decoded_image.getHeight ()
      || decoded_image.getWidth () != image->decoded_image.getWidth ())
  {
    return false ;
  }
  unsigned long imagesize = decoded_image.getHeight () == 0
                            * decoded_image.getWidth ()
                            * sizeof (RGBQUAD) ;
  if (imagesize == 0)
    return true ;

  if (memcmp (&decoded_image [0], &image->decoded_image [0], imagesize) == 0)
    return true ;
  else
    return false ;
}

void __fastcall TCbBitmapImage::ReadData(Classes::TStream* Stream)
{
  iVclStream istream (Stream) ;

  ImageType ReadImage (const std::string &filename,
                BitmapImage &image,
                PROGRESSFUNCTION function,
                void *data)

}

void __fastcall TCbBitmapImage::SetHeight(int Value)
{
  // NoOp
}

void __fastcall TCbBitmapImage::SetWidth(int Value)
{
  // NoOp
}


