//
//  Title:  PNG Output Stream Class
//
//  Copyright 1999, Colosseum Builders, Inc.
//  All rights reserved.
//
//  Colosseum Builders, Inc. makes no warranty, expressed or implied
//  with regards to this software. It is provided as is.
//
//  Author:  John M. Miano (miano@colosseumbuilders.com)
//
//  Date:    March 15, 1999
//
//  Version: 1
//
//  Description:
//
//

#include "pngoutputstream.h"
#include "checks.h"

namespace Colosseum
{
//
//  Description:
//
//    Default Class Constructor
//
PngOutputStream::PngOutputStream ()
{
  memset (chunk_type, 0, sizeof (chunk_type)) ;
  return ;
}
//
//  Description:
//
//    This function starts a new chunk.
//
//  Parameters:
//
//    chunktype : The 4-byte chunk type
//
void PngOutputStream::startChunk (char chunktype [4]) 
{
  ASSERT (memcmp (chunk_type, "\0\0\0\0", sizeof (chunk_type)) == 0) ;
  memcpy (chunk_type, chunktype, sizeof (chunktype)) ;
  return ;
}
//
//  Description:
//
//    This function ends the current chunk.
//
void PngOutputStream::endChunk () 
{
  ASSERT (memcmp (chunk_type, "\0\0\0\0", sizeof (chunk_type)) != 0) ;
  flushBuffer () ;
  memset (chunk_type, 0, sizeof (chunk_type)) ;
  return ;
}


} // End Namespace Colosseum 