//
//  Title:  PNG Output File Stream Class
//
//  Copyright 1999, Colosseum Builders, Inc.
//  All rights reserved.
//
//  Colosseum Builders, Inc. makes no warranty, expressed or implied
//  with regards to this software. It is provided as is.
//
//  Author:  John M. Miano (miano@colosseumbuilders.com)
//
//  Date:    March 15, 1999
//
//  Version: 1
//
//  Description:
//
//

#include "checks.h"
#include "pngoutputfilestream.h"
#include "crc32.h"
using namespace std ;

namespace Colosseum
{
//
//  Description:
//
//    Default class constructor
//
PngOutputFileStream::PngOutputFileStream () 
: output_buffer (0),
  buffer_size (1 << 16) 
{
  return ;
}

//
//  Description:
//
//    Class Destructor
//
PngOutputFileStream::~PngOutputFileStream () 
{
  close () ;
  return ;
}

//
//  Description:
//
//    This function writes the contents of the buffer to 
//    the output stream
//
void PngOutputFileStream::flushBuffer () 
{
  ASSERT (memcmp (chunk_type, "\0\0\0\0", sizeof (chunk_type)) != 0) ;
  Crc32 crc ;
  crc.update (chunk_type, sizeof (chunk_type)) ;
  unsigned int length = current_byte - output_buffer ;
  crc.update (reinterpret_cast<char*>(output_buffer), length) ;
  UBYTE4 chunklength = SystemToBigEndian (length) ;
  output_stream.write (reinterpret_cast<char*>(&chunklength), sizeof (chunklength)) ;
  output_stream.write (reinterpret_cast<char*>(chunk_type), sizeof (chunk_type)) ;
  output_stream.write (reinterpret_cast<char*>(output_buffer), length) ;
  UBYTE4 crcvalue = crc.value () ;
  crcvalue = SystemToBigEndian (crcvalue) ;
  output_stream.write (reinterpret_cast<char*>(&crcvalue), sizeof (crcvalue)) ;
  current_byte = output_buffer ;
  return ;
}
//
//  Description:
//
//    This function opens an output file.
//
//  Parameters:
//
//    filename : The output file name
//
void PngOutputFileStream::open (const std::string &filename) 
{ 
  if (output_buffer == 0) 
    output_buffer = new UBYTE1 [buffer_size] ;
  output_stream.open (filename.c_str (), ios::binary|ios::trunc) ;
  if (output_stream)
  {
    current_byte = output_buffer ;
    buffer_limit = &output_buffer [buffer_size] ;
  }
  return ;
}

//
//  Description:
//
//    This function closes the output file.
//
void PngOutputFileStream::close () 
{
  delete [] output_buffer ; output_buffer = 0 ;
  current_byte = 0 ; 
  buffer_limit = 0 ;
  output_stream.close () ;
  return ;
}

//
//  Description:
//
//    This function returns the state of the output file stream.
//
//  Return Value:
//
//    The state of the output_stream member
//
PngOutputFileStream::operator bool () 
{
#if defined (_MSC_VER)
  bool result = static_cast<void*> (output_stream) != 0 ? true : false ;
#else
  bool result = static_cast<bool> (output_stream) ;
#endif
  return result ;
}

//
//  Description:
//
//    This function writes a string of raw bytes to the output stream,
//    bypassing chunks.
//
//  Parameters:
//
//    buffer : The output buffer
//    size  : The number of bytes to write
//
void PngOutputFileStream::writeRaw (const char* buffer, unsigned int size)
{
  ASSERT (memcmp (chunk_type, "\0\0\0\0", sizeof (chunk_type)) == 0) ;
  output_stream.write (buffer, size) ;
  return ;
}


} // End Namespace Colosseum
