
//
//  Title:  JpegInputFileStream Implementation
//
//  Copyright 1997-1999, Colosseum Builders, Inc.
//  All rights reserved.
//
//  Colosseum Builders, Inc. makes no warranty, expressed or implied
//  with regards to this software. It is provided as is.
//
//  Author:  John M. Miano (miano@colosseumbuilders.com)
//
//  Date:    March 15, 1999
//
//  Version: 1
//
//  Description:
//
//    JpegInputFileStream implements JPEG input through a file.
//
//  Revision History:
//
//

#include <fstream>
#include "jpginputfilestream.h"

using namespace std ;

namespace Colosseum 
{
//
//  Description:
//
//    Default Constructor
//
JpegInputFileStream::JpegInputFileStream (unsigned int buffersize) 
: buffer_size (buffersize),
  input_buffer (new UBYTE1 [buffer_size]) 
{
  return ;
}
//
//  Description:
//
//    Class Destructor
//
JpegInputFileStream::~JpegInputFileStream () 
{
  delete [] input_buffer ; input_buffer = 0 ;
  return ;
}
//
//  Description:
//
//    This function gives access to the state of the input stream.
//
//  Return Value:
//
//    The state of the input stream.
//
JpegInputFileStream::operator bool () 
{
#if defined (_MSC_VER)
  bool result = static_cast<void*> (input_stream) != 0 ? true : false ;
#else
  bool result = static_cast<bool> (input_stream) ;
#endif
  return result ;
}
//
//  Description:
//
//    This function opens the input file.
//
//  Parameters:
//
//    filename : The name of the file to open
//
void JpegInputFileStream::open (const std::string &filename) 
{
  input_stream.open (filename.c_str (), ios::binary) ;
  return ;
}
//
//  Description:
//
//    This function closes the input stream.
//
void JpegInputFileStream::close () 
{
  if (input_stream)
    input_stream.close () ;

  return ;
}
//
//  Description:
//
//    This function reads the input stream and fills the input buffer.
//  
void JpegInputFileStream::fillBuffer () 
{
  input_stream.read (reinterpret_cast<char*>(input_buffer), buffer_size) ;
  int count = input_stream.gcount () ;
  if (count <= 0)
  {
    current_byte = 0 ;
    buffer_limit = 0 ;
  }
  else
  {
    current_byte = input_buffer ;
    buffer_limit = &input_buffer [count] ;
  }
  return ;
}
//
//  Description:
//
//    This function tells the caller if the end of the input stream
//    has been reached.
//
//  Return Value:
//  
//    true => The end of file has been reached
//    false => The end of file has not been reached
//
bool JpegInputFileStream::endReached () 
{
  return input_stream.eof () ;
}

//
//  Description:
//
//    This function returns the current position in the input stream.
//
//  Return Value:
//
//    The current input position.
//
InputByteStream::POSITIONTYPE JpegInputFileStream::tellg () 
{
  InputByteStream::POSITIONTYPE result = input_stream.tellg () ;
  result -= buffer_limit - current_byte ;
  return result ;
}
//
//  Description:
//
//    This function moves the input stream to a specified position.
//
//  Parameters:
//
//    position: The absolute position in the input stream to move to.
//
void JpegInputFileStream::seekg (InputByteStream::POSITIONTYPE position) 
{
  exitBitMode () ;
  input_stream.clear () ;
  input_stream.seekg (position) ;
  fillBuffer () ;
  return ;
}

} // End Namespace 