//
// Copyright (c) 1997,1998 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// See the README.TXT file that came with this software for restrictions
// on the use and redistribution of this file or send E-mail to
// info@colosseumbuilders.com
//

//
// Title:   JFIF Implementation
//
// Author: John M. Miano  miano@colosseumbuilders.com
//
// Description:
//
//    This module contains the RGB/YcbCr conversion functions specified
//    by the JFIF standard. This functions are implemented using scaled
//    integers.
//
//    If you are using MS C++ you may wish to re-write this since that compile
//    generates terrible code for these function. Borland C++ is great here,
//    and G++ works well if you turn on optimizations.
//


#include "jfif.h"

#if ! defined (INLINECOLORCONVERSION)

const int ScaleFactor = 12 ;
const int ScaleValue = (1<<ScaleFactor) ;
const int Rounding = (1<<(ScaleFactor-1)) ;

namespace
{
inline int Scaled (double value)
{
  return (int) (ScaleValue * value) ;
}
}

namespace ColosseumPrivate
{
JPEGSAMPLE YCbCrToR (int yy, int /*cb*/, int cr)
{
  int result = yy + ((Scaled (1.402) * (cr - JPEGMIDPOINTSAMPLEVALUE) + Rounding) >> ScaleFactor) ;
  if (result < 0)
    result = 0 ;
  else if (result > JPEGMAXSAMPLEVALUE)
    result = JPEGMAXSAMPLEVALUE ;
  return static_cast<JPEGSAMPLE>(result) ;
}

JPEGSAMPLE YCbCrToG (int yy, int cb, int cr)
{
  int result = yy - ((Scaled (0.34414) * (cb - JPEGMIDPOINTSAMPLEVALUE)
                     + Scaled (0.71414) * (cr - JPEGMIDPOINTSAMPLEVALUE)
                     + Rounding) >> ScaleFactor) ;
  if (result < 0)
    result = 0 ;
  else if (result > JPEGMAXSAMPLEVALUE)
    result = JPEGMAXSAMPLEVALUE ;
  return static_cast<JPEGSAMPLE>(result) ;
}

JPEGSAMPLE YCbCrToB (int yy, int cb, int /*cr*/)
{
  int result = yy + ((Scaled (1.772) * (cb - JPEGMIDPOINTSAMPLEVALUE)
             + Rounding) >> ScaleFactor) ;
  if (result < 0)
    result = 0 ;
  else if (result > JPEGMAXSAMPLEVALUE)
    result = JPEGMAXSAMPLEVALUE ;
  return static_cast<JPEGSAMPLE>(result) ;
}

JPEGSAMPLE RgbToY (JPEGSAMPLE red, JPEGSAMPLE green, JPEGSAMPLE blue)
{
  int result = (Scaled (0.299) * red
             + Scaled (0.587) * green + Scaled (0.114) * blue
             + Rounding) >> ScaleFactor ;
  if (result > JPEGMAXSAMPLEVALUE)
  	result = JPEGMAXSAMPLEVALUE ;
  else if (result < JPEGMINSAMPLEVALUE)
  	result = JPEGMINSAMPLEVALUE ;
  return static_cast<JPEGSAMPLE>(result) ;
}

JPEGSAMPLE RgbToCb (JPEGSAMPLE red, JPEGSAMPLE green, JPEGSAMPLE blue)
{
  int result = ((JPEGMIDPOINTSAMPLEVALUE<<ScaleFactor)
             + Rounding - Scaled (0.1687) * red
             - Scaled (0.3313) * green + Scaled (0.5) * blue) >> ScaleFactor  ;
  if (result > JPEGMAXSAMPLEVALUE)
  	result = JPEGMAXSAMPLEVALUE ;
  else if (result < JPEGMINSAMPLEVALUE)
  	result = JPEGMINSAMPLEVALUE ;
  return static_cast<JPEGSAMPLE>(result) ;
}

JPEGSAMPLE RgbToCr (JPEGSAMPLE red, JPEGSAMPLE green, JPEGSAMPLE blue)
{
  int result = ((JPEGMIDPOINTSAMPLEVALUE<<ScaleFactor)
             + Rounding + Scaled (0.5) * red
             - Scaled (0.4187) * green - Scaled (0.0813) * blue) >> ScaleFactor ;
  if (result > JPEGMAXSAMPLEVALUE)
  	result = JPEGMAXSAMPLEVALUE ;
  else if (result < JPEGMINSAMPLEVALUE)
  	result = JPEGMINSAMPLEVALUE ;
  return static_cast<JPEGSAMPLE>(result) ;
}

}
#else
namespace ColosseumPrivate
{
// CrRTable [x] =  ROUND (x * 1.402)
extern const long CrRTable [256] =
{
-179, -178, -177, -175, -174, -172, -171, -170,
-168, -167, -165, -164, -163, -161, -160, -158,
-157, -156, -154, -153, -151, -150, -149, -147,
-146, -144, -143, -142, -140, -139, -137, -136,
-135, -133, -132, -130, -129, -128, -126, -125,
-123, -122, -121, -119, -118, -116, -115, -114,
-112, -111, -109, -108, -107, -105, -104, -102,
-101, -100,  -98,  -97,  -95,  -94,  -93,  -91,
 -90,  -88,  -87,  -86,  -84,  -83,  -81,  -80,
 -79,  -77,  -76,  -74,  -73,  -72,  -70,  -69,
 -67,  -66,  -64,  -63,  -62,  -60,  -59,  -57,
 -56,  -55,  -53,  -52,  -50,  -49,  -48,  -46,
 -45,  -43,  -42,  -41,  -39,  -38,  -36,  -35,
 -34,  -32,  -31,  -29,  -28,  -27,  -25,  -24,
 -22,  -21,  -20,  -18,  -17,  -15,  -14,  -13,
 -11,  -10,   -8,   -7,   -6,   -4,   -3,   -1,
   0,    1,    3,    4,    6,    7,    8,   10,
  11,   13,   14,   15,   17,   18,   20,   21,
  22,   24,   25,   27,   28,   29,   31,   32,
  34,   35,   36,   38,   39,   41,   42,   43,
  45,   46,   48,   49,   50,   52,   53,   55,
  56,   57,   59,   60,   62,   63,   64,   66,
  67,   69,   70,   72,   73,   74,   76,   77,
  79,   80,   81,   83,   84,   86,   87,   88,
  90,   91,   93,   94,   95,   97,   98,  100,
 101,  102,  104,  105,  107,  108,  109,  111,
 112,  114,  115,  116,  118,  119,  121,  122,
 123,  125,  126,  128,  129,  130,  132,  133,
 135,  136,  137,  139,  140,  142,  143,  144,
 146,  147,  149,  150,  151,  153,  154,  156,
 157,  158,  160,  161,  163,  164,  165,  167,
 168,  170,  171,  172,  174,  175,  177,  178,
} ;
// CbGTable [x] = ROUND ((ii-128) << 16) * 0.33414)
extern const long CbGTable [256] =
{
-2802969, -2781071, -2759173, -2737275, -2715377, -2693478, -2671580, -2649682,
-2627784, -2605886, -2583987, -2562089, -2540191, -2518293, -2496395, -2474496,
-2452598, -2430700, -2408802, -2386904, -2365005, -2343107, -2321209, -2299311,
-2277413, -2255515, -2233616, -2211718, -2189820, -2167922, -2146024, -2124125,
-2102227, -2080329, -2058431, -2036533, -2014634, -1992736, -1970838, -1948940,
-1927042, -1905143, -1883245, -1861347, -1839449, -1817551, -1795652, -1773754,
-1751856, -1729958, -1708060, -1686161, -1664263, -1642365, -1620467, -1598569,
-1576670, -1554772, -1532874, -1510976, -1489078, -1467179, -1445281, -1423383,
-1401485, -1379587, -1357688, -1335790, -1313892, -1291994, -1270096, -1248197,
-1226299, -1204401, -1182503, -1160605, -1138706, -1116808, -1094910, -1073012,
-1051114, -1029215, -1007317,  -985419,  -963521,  -941623,  -919724,  -897826,
 -875928,  -854030,  -832132,  -810233,  -788335,  -766437,  -744539,  -722641,
 -700742,  -678844,  -656946,  -635048,  -613150,  -591251,  -569353,  -547455,
 -525557,  -503659,  -481760,  -459862,  -437964,  -416066,  -394168,  -372269,
 -350371,  -328473,  -306575,  -284677,  -262778,  -240880,  -218982,  -197084, 
 -175186,  -153287,  -131389,  -109491,   -87593,   -65695,   -43796,   -21898,
       0,    21898,    43796,    65695,    87593,   109491,   131389,   153287, 
  175186,   197084,   218982,   240880,   262778,   284677,   306575,   328473,
  350371,   372269,   394168,   416066,   437964,   459862,   481760,   503659,
  525557,   547455,   569353,   591251,   613150,   635048,   656946,   678844, 
  700742,   722641,   744539,   766437,   788335,   810233,   832132,   854030,
  875928,   897826,   919724,   941623,   963521,   985419,  1007317,  1029215,
 1051114,  1073012,  1094910,  1116808,  1138706,  1160605,  1182503,  1204401,
 1226299,  1248197,  1270096,  1291994,  1313892,  1335790,  1357688,  1379587,
 1401485,  1423383,  1445281,  1467179,  1489078,  1510976,  1532874,  1554772,
 1576670,  1598569,  1620467,  1642365,  1664263,  1686161,  1708060,  1729958,
 1751856,  1773754,  1795652,  1817551,  1839449,  1861347,  1883245,  1905143,
 1927042,  1948940,  1970838,  1992736,  2014634,  2036533,  2058431,  2080329,
 2102227,  2124125,  2146024,  2167922,  2189820,  2211718,  2233616,  2255515,
 2277413,  2299311,  2321209,  2343107,  2365005,  2386904,  2408802,  2430700,
 2452598,  2474496,  2496395,  2518293,  2540191,  2562089,  2583987,  2605886,
 2627784,  2649682,  2671580,  2693478,  2715377,  2737275,  2759173,  2781071,
} ;
// CrGTable [x] = ROUND ((ii-128) << 16) * 0.71414)
extern const long CrGTable [256] =
{
-5990641, -5943839, -5897037, -5850235, -5803433, -5756631, -5709829, -5663027,
-5616225, -5569424, -5522622, -5475820, -5429018, -5382216, -5335414, -5288612,
-5241810, -5195009, -5148207, -5101405, -5054603, -5007801, -4960999, -4914197,
-4867395, -4820594, -4773792, -4726990, -4680188, -4633386, -4586584, -4539782,
-4492980, -4446179, -4399377, -4352575, -4305773, -4258971, -4212169, -4165367,
-4118565, -4071763, -4024962, -3978160, -3931358, -3884556, -3837754, -3790952,
-3744150, -3697348, -3650547, -3603745, -3556943, -3510141, -3463339, -3416537,
-3369735, -3322933, -3276132, -3229330, -3182528, -3135726, -3088924, -3042122,
-2995320, -2948518, -2901717, -2854915, -2808113, -2761311, -2714509, -2667707,
-2620905, -2574103, -2527301, -2480500, -2433698, -2386896, -2340094, -2293292,
-2246490, -2199688, -2152886, -2106085, -2059283, -2012481, -1965679, -1918877,
-1872075, -1825273, -1778471, -1731670, -1684868, -1638066, -1591264, -1544462,
-1497660, -1450858, -1404056, -1357254, -1310453, -1263651, -1216849, -1170047,
-1123245, -1076443, -1029641,  -982839,  -936038,  -889236,  -842434,  -795632, 
 -748830,  -702028,  -655226,  -608424,  -561623,  -514821,  -468019,  -421217,
 -374415,  -327613,  -280811,  -234009,  -187208,  -140406,   -93604,   -46802,
       0,    46802,    93604,   140406,   187208,   234009,   280811,   327613,
  374415,   421217,   468019,   514821,   561623,   608424,   655226,   702028,
  748830,   795632,   842434,   889236,   936038,   982839,  1029641,  1076443, 
 1123245,  1170047,  1216849,  1263651,  1310453,  1357254,  1404056,  1450858,
 1497660,  1544462,  1591264,  1638066,  1684868,  1731670,  1778471,  1825273, 
 1872075,  1918877,  1965679,  2012481,  2059283,  2106085,  2152886,  2199688, 
 2246490,  2293292,  2340094,  2386896,  2433698,  2480500,  2527301,  2574103, 
 2620905,  2667707,  2714509,  2761311,  2808113,  2854915,  2901717,  2948518,
 2995320,  3042122,  3088924,  3135726,  3182528,  3229330,  3276132,  3322933, 
 3369735,  3416537,  3463339,  3510141,  3556943,  3603745,  3650547,  3697348, 
 3744150,  3790952,  3837754,  3884556,  3931358,  3978160,  4024962,  4071763, 
 4118565,  4165367,  4212169,  4258971,  4305773,  4352575,  4399377,  4446179,
 4492980,  4539782,  4586584,  4633386,  4680188,  4726990,  4773792,  4820594,
 4867395,  4914197,  4960999,  5007801,  5054603,  5101405,  5148207,  5195009, 
 5241810,  5288612,  5335414,  5382216,  5429018,  5475820,  5522622,  5569424,
 5616225,  5663027,  5709829,  5756631,  5803433,  5850235,  5897037,  5943839,
} ;
// CbBTable [X] = ROUND ((x-128) * 1.772)
extern const long CbBTable [256] =
{
-227, -225, -223, -222, -220, -218, -216, -214,
-213, -211, -209, -207, -206, -204, -202, -200,
-198, -197, -195, -193, -191, -190, -188, -186,
-184, -183, -181, -179, -177, -175, -174, -172,
-170, -168, -167, -165, -163, -161, -159, -158, 
-156, -154, -152, -151, -149, -147, -145, -144,
-142, -140, -138, -136, -135, -133, -131, -129, 
-128, -126, -124, -122, -120, -119, -117, -115, 
-113, -112, -110, -108, -106, -105, -103, -101, 
 -99,  -97,  -96,  -94,  -92,  -90,  -89,  -87, 
 -85,  -83,  -82,  -80,  -78,  -76,  -74,  -73,
 -71,  -69,  -67,  -66,  -64,  -62,  -60,  -58,
 -57,  -55,  -53,  -51,  -50,  -48,  -46,  -44,
 -43,  -41,  -39,  -37,  -35,  -34,  -32,  -30, 
 -28,  -27,  -25,  -23,  -21,  -19,  -18,  -16,
 -14,  -12,  -11,   -9,   -7,   -5,   -4,   -2,
   0,    2,    4,    5,    7,    9,   11,   12, 
  14,   16,   18,   19,   21,   23,   25,   27,
  28,   30,   32,   34,   35,   37,   39,   41,
  43,   44,   46,   48,   50,   51,   53,   55, 
  57,   58,   60,   62,   64,   66,   67,   69,
  71,   73,   74,   76,   78,   80,   82,   83,
  85,   87,   89,   90,   92,   94,   96,   97,
  99,  101,  103,  105,  106,  108,  110,  112, 
 113,  115,  117,  119,  120,  122,  124,  126,
 128,  129,  131,  133,  135,  136,  138,  140,
 142,  144,  145,  147,  149,  151,  152,  154, 
 156,  158,  159,  161,  163,  165,  167,  168,
 170,  172,  174,  175,  177,  179,  181,  183, 
 184,  186,  188,  190,  191,  193,  195,  197,
 198,  200,  202,  204,  206,  207,  209,  211, 
 213,  214,  216,  218,  220,  222,  223,  225,
} ;


} // End Namespace ColosseumPrivate

#endif
