#ifndef CB__JPGQTBLS_H
#define CB__JPGQTBLS_H
// Copyright (c) 2000 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// See the README.TXT file that came with this software for restrictions
// on the use and redistribution of this file or send E-mail to
// info@colosseumbuilders.com
//

//
// JPEG Encoder Library.
//
// Title:   Quantization Table Definitions
//
// Author: John M. Miano  miano@colosseumbuilders.com
//
// Description:
// 
//   These are some quantization tables from various sources. These
//   sources include:
//
//   o The JPEG Standard (JPEG)
//   o The National Imagery transmission Format Standard
//      - Bandwidth Compression Standards and Guidelines (NIMA)
//   o DoD JPEG Image Compression for the National Imagery Transmission Format Standard
//

#define QTABLEWORST {\
255, 255, 255, 255, 255, 255, 255, 255, \
255, 255, 255, 255, 255, 255, 255, 255, \
255, 255, 255, 255, 255, 255, 255, 255, \
255, 255, 255, 255, 255, 255, 255, 255, \
255, 255, 255, 255, 255, 255, 255, 255, \
255, 255, 255, 255, 255, 255, 255, 255, \
255, 255, 255, 255, 255, 255, 255, 255, \
255, 255, 255, 255, 255, 255, 255, 255, \
}

#define QTABLENIMAQ1 {\
 13,  13,  15,  25,  40,  68, 114, 201, \
 13,  16,  22,  32,  49,  79, 131, 230, \
 16,  22,  38,  54,  78, 117, 188, 255, \
 26,  33,  56,  93, 142, 213, 255, 255, \
 45,  54,  84, 149, 255, 255, 255, 255, \
 79,  92, 134, 237, 255, 255, 255, 255, \
144, 165, 232, 255, 255, 255, 255, 255, \
255, 255, 255, 255, 255, 255, 255, 255, \
}

#define QTABLEDODQ1 {\
  8,  72,  72,  72,  78,  89, 106, 129, \
 72,  72,  72,  74,  81,  93, 111, 135, \
 72,  72,  76,  84,  94, 108, 128, 155, \
 72,  74,  84,  99, 116, 136, 160, 193, \
 78,  81,  94, 116, 145, 177, 213, 255, \
 89,  93, 108, 136, 177, 228, 255, 255, \
106, 111, 128, 160, 213, 255, 255, 255, \
129, 135, 155, 193, 255, 255, 255, 255, \
}

// K.1 Table K-1
#define QTABLEJPEGL1 {\
 16,  11,  10,  16,  24,  40,  51,  61, \
 12,  12,  14,  19,  26,  58,  60,  55, \
 14,  13,  16,  24,  40,  57,  69,  56, \
 14,  17,  22,  29,  51,  87,  80,  62, \
 18,  22,  37,  56,  68, 109, 103,  77, \
 24,  35,  55,  64,  81, 104, 113,  92, \
 49,  64,  78,  87, 103, 121, 120, 101, \
 72,  92,  95,  98, 112, 100, 103,  99, \
}

#define QTABLEDODQ2 {\
  8,  36,  36,  36,  39,  45,  53,  65, \
 36,  36,  36,  37,  41,  47,  56,  68, \
 36,  36,  38,  42,  47,  54,  64,  78, \
 36,  37,  42,  50,  59,  69,  81,  98, \
 39,  41,  47,  59,  73,  89, 108, 130, \
 45,  47,  54,  69,  89, 115, 144, 178, \
 53,  56,  64,  81, 108, 144, 190, 243, \
 65,  68,  78,  98, 130, 178, 243, 255, \
}

#define QTABLENIMAQ2 {\
  8,   8,   8,  12,  19,  32,  50,  83, \
  8,   8,  11,  15,  23,  35,  57,  93, \
  9,  11,  18,  25,  35,  50,  77, 124, \
 13,  16,  26,  41,  59,  84, 126, 196, \
 21,  25,  38,  62,  99, 151, 230, 255, \
 36,  41,  58,  94, 161, 255, 255, 255, \
 63,  71,  95, 150, 255, 255, 255, 255, \
115, 127, 166, 255, 255, 255, 255, 255, \
}

#define QTABLENIMAQ3 {\
 10,  10,  10,  10,  10,  11,  15,  20, \
 10,  10,  10,  10,  10,  12,  16,  21, \
 10,  10,  10,  10,  11,  14,  18,  25, \
 10,  10,  10,  12,  14,  18,  23,  32, \
 11,  11,  12,  15,  19,  25,  32,  44, \
 13,  14,  16,  20,  26,  35,  47,  63, \
 18,  20,  22,  28,  37,  50,  68,  94, \
 28,  29,  33,  41,  54,  74, 102, 143, \
}

#define QTABLEDODQ3 {\
  8,  10,  10,  10,  11,  13,  15,  18, \
 10,  10,  10,  10,  11,  13,  16,  19, \
 10,  10,  11,  12,  13,  15,  18,  22, \
 10,  10,  12,  14,  16,  19,  23,  27, \
 11,  11,  13,  16,  21,  25,  30,  36, \
 13,  13,  15,  19,  25,  32,  40,  50, \
 15,  16,  18,  23,  30,  40,  53,  68, \
 18,  19,  22,  27,  36,  50,  68,  91, \
}

#define QTABLEDODQ4 {\
  8,   7,   7,   7,   8,   9,  11,  13, \
  7,   7,   7,   7,   8,   9,  11,  14, \
  7,   7,   8,   8,   9,  11,  13,  16, \
  7,   7,   8,  10,  12,  14,  16,  20, \
  8,   8,   9,  12,  15,  18,  22,  26, \
  9,   9,  11,  14,  18,  23,  29,  36, \
 11,  11,  13,  16,  22,  29,  38,  49, \
 13,  14,  16,  20,  26,  36,  49,  65, \
}

// K.1 Table K-1 (Each Element Divided By 2)
#define QTABLEJPEGL2 {\
  8,   5,   5,   8,  12,  20,  25,  30, \
  6,   6,   7,   9,  13,  28,  30,  27, \
  7,   6,   8,  12,  20,  26,  34,  28, \
  7,   8,  11,  14,  25,  43,  40,  31, \
  9,  11,  18,  28,  34,  54,  51,  38, \
 12,  17,  27,  32,  40,  52,  56,  46, \
 24,  32,  39,  43,  51,  60,  60,  50, \
 36,  46,  47,  49,  56,  50,  51,  49, \
}

// NIMA Q4 and DoD Q5
#define QTABLENIMAQ4 {\
  4,   4,   4,   4,   4,   5,   6,   7, \
  4,   4,   4,   4,   5,   5,   6,   8, \
  4,   4,   4,   5,   5,   6,   7,   9, \
  4,   4,   5,   6,   6,   8,   9,  11, \
  4,   5,   5,   6,   8,  10,  12,  14, \
  5,   5,   6,   8,  10,  13,  16,  20, \
  6,   6,   7,   9,  12,  16,  21,  27, \
  7,   8,   9,  11,  14,  20,  27,  36, \
}

// NIMA Q5
#define QTABLEBEST {\
  1,   1,   1,   1,   1,   1,   1,   1, \
  1,   1,   1,   1,   1,   1,   1,   1, \
  1,   1,   1,   1,   1,   1,   1,   1, \
  1,   1,   1,   1,   1,   1,   1,   1, \
  1,   1,   1,   1,   1,   1,   1,   1, \
  1,   1,   1,   1,   1,   1,   1,   1, \
  1,   1,   1,   1,   1,   1,   1,   1, \
  1,   1,   1,   1,   1,   1,   1,   1, \
}

#define QTABLENIMADOWNSAMPLE {\
 36,  36,  37,  39,  42,  45,  50,  54, \
 36,  37,  39,  42,  45,  50,  54,  60, \
 37,  39,  42,  45,  50,  54,  60,  66, \
 39,  42,  45,  50,  54,  60,  66,  74, \
 42,  45,  50,  54,  60,  66,  74,  81, \
 45,  50,  54,  60,  66,  74,  81,  90, \
 50,  54,  60,  66,  74,  81,  90,  99, \
 54,  60,  66,  74,  81,  90,  88, 110, \
}

// K.1 Table K-2
#define QTABLEJPEGC1 {\
 17,  18,  24,  47,  99,  99,  99,  99, \
 18,  21,  26,  66,  99,  99,  99,  99, \
 24,  26,  56,  99,  99,  99,  99,  99, \
 47,  66,  99,  99,  99,  99,  99,  99, \
 99,  99,  99,  99,  99,  99,  99,  99, \
 99,  99,  99,  99,  99,  99,  99,  99, \
 99,  99,  99,  99,  99,  99,  99,  99, \
 99,  99,  99,  99,  99,  99,  99,  99, \
} 

//K.1 Table K-2 (Each Element Divided By 2)
#define QTABLEJPEGC2 {\
  8,   9,  12,  23,  49,  49,  49,  49, \
  9,  10,  13,  33,  49,  49,  49,  49, \
 12,  13,  28,  49,  49,  49,  49,  49, \
 23,  33,  49,  49,  49,  49,  49,  49, \
 49,  49,  49,  49,  49,  49,  49,  49, \
 49,  49,  49,  49,  49,  49,  49,  49, \
 49,  49,  49,  49,  49,  49,  49,  49, \
 49,  49,  49,  49,  49,  49,  49,  49, \
}

#endif 
