#ifndef CB__ARRAY_H
#define CB__ARRAY_H
//
//  Title: Array Class
//
//  Author:  John M. Miano  miano@colosseumbuilders.com
//
//  Copyright 1999 Colosseum Builders, Inc.
//
//  Description:
//
//    The Array template class is a wrapper for the STL vector class 
//    that allows range checking to be enabled and disabled.
//
//    If the preprocessor symbol ENABLECHECKS is enabled range checking
//    is enabled.
//

#include <vector>
#include "checks.h"

namespace ColosseumPrivate
{
template<class TYPE>
class Array : public std::vector<TYPE>
{
public:
  Array () {} 
  Array (size_t size) : vector<TYPE>(size) {} 
  Array (size_t size, const TYPE &value) : vector<TYPE>(size, value) {} 
  Array (const Array &source) : vector<TYPE>(source) {} 
  TYPE &operator[](size_t) ;
  const TYPE &operator[] (size_t) const ;
} ;

#if defined (ENABLECHECKS)
template<class TYPE>
inline TYPE &Array<TYPE>::operator[](size_t index)
{
  return vector<TYPE>::at (index) ;
}
template<class TYPE>
inline const TYPE &Array<TYPE>::operator[](size_t index) const
{
  return vector<TYPE>::at (index) ;
}
#else
template<class TYPE>
inline TYPE &Array<TYPE>::operator[](size_t index)
{
  return vector<TYPE>::operator[](index) ;
}
template<class TYPE>
inline const TYPE &Array<TYPE>::operator[](size_t index) const
{
  return vector<TYPE>::operator[](index) ;
}
#endif

}

#endif
