#include <iostream>

#include "pngdecoder.h"
#include "bmpencoder.h"

using namespace std ;
using namespace Colosseum ;

void ProgressFunction (BitmapImageCoder &,
                      void *,
                      unsigned int currentpass,
                      unsigned int passcount,
                      unsigned int progress,
                      bool &)
{
}

void Usage (int argc, char *argv [])
{
  char *program ;
  if (argc == 0)
    program = "pngdecoder" ;
  else
    program = argv [0] ;

  cout << program << " input-file output-file" << endl ;
  exit (1) ;
  return ;
}

main (int argc, char *argv [])
{
  if (argc < 3)
    Usage (argc, argv) ;

  PngDecoder decoder ;
  decoder.setProgressFunction (ProgressFunction, 0) ;
  for (unsigned int ii = 1 ; ii < argc - 2 ; ++ ii)
  {
    if (argv [ii][0] != '-')
      Usage (argc, argv) ;

    switch (argv [ii][1])
    {
    case 'v':
      decoder.setVerbose (true) ;
      break ;
    default:
      Usage (argc, argv) ;
    }
  }

  BitmapImage image ;
  try
  {
    string in = argv [argc-2] ;
    decoder.readImageFile (in.c_str (), image) ;
  }
  catch (exception &ee)
  {
    cout << "-----> " << ee.what () << endl ;
  }

  BmpEncoder encoder ;
  try
  {
    string out = argv [argc-1] ;
    encoder.writeImageFile (out.c_str (), image) ;
  }
  catch (exception &ee)
  {
    cout << ee.what () << endl ;
  }
  return 0 ;
}
