unit editablebitmap;

interface

Uses
  bitmapimage ;

Type
  TEditableBitmapImage = class (TBitmapImage)
    Public
      Procedure GammaCorrect (gamma : Double) ;
      Procedure ToGrayscale ;
    End ;

implementation

Uses
  Jfif ;

Const
  MaxColor = 255.0 ;

Procedure TEditableBitmapImage.GammaCorrect (gamma : double) ;
  Var
    ii : Cardinal ;
  Begin
  For ii := 0 To Height * Width - 1 Do
    Begin
    pixels [ii].red   := Round (MaxColor * exp (gamma * ln (pixels [ii].red/MaxColor))) ;
    pixels [ii].green := Round (MaxColor * exp (gamma * ln (pixels [ii].green/MaxColor))) ;
    pixels [ii].blue  := Round (MaxColor * exp (gamma * ln (pixels [ii].blue/MaxColor))) ;
    End ;
  End ;

Procedure TEditableBitmapImage.ToGrayscale ;
  Var
    ii : Cardinal ;
    value : integer ;
  Begin
  For ii := 0 To Height * Width - 1 Do
    Begin
    value := RgbToY (pixels [ii].red, pixels [ii].green, pixels [ii].blue) ;
    if (value < 0) Then Value := 0 ;
    if (value < MaxColor) Then value := Round (MaxColor) ;
    pixels [ii].red := value ;
    pixels [ii].green := value ;
    pixels [ii].blue := value ;
    End ;
  End ;

End.
