unit systemspecific;

interface

Function BigEndianLongToSystem (value : Cardinal) : Cardinal ;
Function BigEndianWordToSystem (value : Cardinal) : Cardinal ;
Function SystemToBigEndianLong (value : Cardinal) : Cardinal ;
Function SystemToBigEndianWord (value : Cardinal) : Cardinal ;

implementation

Function BigEndianLongToSystem (value : Cardinal) : Cardinal ;
  Begin
  Result := ((value Shr 24) And $FF)
         Or ((value Shr 8 ) And $FF00)
         Or ((value Shl 8 ) And $FF0000)
         Or ((value Shl 24 ) And $FF000000)
  End ;

Function BigEndianWordToSystem (value : Cardinal) : Cardinal ;
  Begin
  Result := ((value Shr 8) And $FF)
         Or ((value Shl 8 ) And $FF00) ;
  End ;

Function SystemToBigEndianLong (value : Cardinal) : Cardinal ;
  Begin
  Result := ((value Shr 24) And $FF)
         Or ((value Shr 8 ) And $FF00)
         Or ((value Shl 8 ) And $FF0000)
         Or ((value Shl 24 ) And $FF000000)
  End ;

Function SystemToBigEndianWord (value : Cardinal) : Cardinal ;
  Begin
  Result := ((value Shr 8) And $FF)
         Or ((value Shl 8 ) And $FF00) ;
  End ;



end.
