unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  BmpDecoder, BitmapImage, JpegDecoder, PngDecoder ;

type
  TForm1 = class(TForm)
    procedure FormPaint(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    Procedure WmDropFiles (var msg : TMessage) ; Message WM_DROPFILES ;
  public
    image : TBitmapImage ;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Uses
  shellapi, imagetype ;

Type
  BITMAPV4HEADER = packed record
    bV4Size: DWORD;
    bV4Width: Longint;
    bV4Height: Longint;
    bV4Planes: Word;
    bV4BitCount: Word;
    bV4V4Compression: DWORD;
    bV4SizeImage: DWORD;
    bV4XPelsPerMeter: Longint;
    bV4YPelsPerMeter: Longint;
    bV4ClrUsed: DWORD;
    bV4ClrImportant: DWORD;
    bV4RedMask: DWORD;
    bV4GreenMask: DWORD;
    bV4BlueMask: DWORD;
    bV4AlphaMask: DWORD;
    bV4CSType: DWORD;
    bV4Endpoints: TCIEXYZTriple;
    bV4GammaRed: DWORD;
    bV4GammaGreen: DWORD;
    bV4GammaBlue: DWORD;
  end;

Procedure ProgressFunction (code : TBitmapImageDecoder ;
			    data : PROGRESSDATA ;
			    currentpass : Cardinal ;
			    passcount : Cardinal ;
			    progress : Cardinal ;
			    var cancel : Boolean) ;
  Begin
  Form1.Caption := IntToStr (progress) + ' %' ;
  If progress = 100 Then
    Begin
    code.UpdateImage ;
    Form1.Invalidate ;
    End ;
  Application.ProcessMessages ;
  End ;


procedure TForm1.FormPaint(Sender: TObject);
var
   imageheader : BITMAPV4HEADER ;
   header : ^TBitmapInfo ;
   temp : integer ;
begin
if Assigned (image) And (image.Width > 0) Then
  Begin
      imageheader.bV4Size := sizeof (BITMAPV4HEADER) ;
      imageheader.bV4Width := image.Width ;
      temp := image.Height ;
      temp := - temp ;
        imageheader.bV4Height := temp ;
        imageheader.bV4Planes := 1 ;
        imageheader.bV4BitCount := 32 ;
        imageheader.bV4V4Compression := BI_BITFIELDS ;
        imageheader.bV4SizeImage := 0 ;
        imageheader.bV4XPelsPerMeter := 0 ;
        imageheader.bV4YPelsPerMeter := 0 ;
        imageheader.bV4ClrUsed := 0 ;
        imageheader.bV4ClrImportant := 0 ;
        imageheader.bV4BlueMask := $FF ;
        imageheader.bV4GreenMask := $FF00 ;
        imageheader.bV4RedMask := $FF0000 ;
        imageheader.bV4AlphaMask := $FF000000 ;

        header := @imageheader ;
        SetDIBitsToDevice (Canvas.handle,
                           0,
                           0,
                           image.Width,
                           image.Height,
                           0,
                           0,
                           0,
                           image.Height,
                           @image.Pixels [0],
                           header^,
                           DIB_RGB_COLORS) ;
  End ;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
DragAcceptFiles (Handle, true) ;

end;

Procedure TForm1.WmDropFiles (var msg : TMessage) ;
  Var
    filename : Array [1..MAX_PATH] of Char ;
    itype : TImageType ;
    //  decoder : BmpDecoder ;
//  decoder : BitmapImageDecoder ;
//    decoder : TJpegDecoder ;
    decoder : TPngDecoder ;
  Begin
  DragQueryFile (msg.WParam, 0, @filename, sizeof (filename)) ;
  Caption := filename ;
  DragFinish (msg.WParam) ;
  itype := ReadImage (filename, image, ProgressFunction, Nil) ;
  if itype = UnknownImage Then
    ShowMessage ('Unknown image type: ' + filename) ;
  End ;


procedure TForm1.FormCreate(Sender: TObject);
begin
image := TBitmapImage.Create ;
end;

end.
