//
// Copyright (c) 1998 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// Permission to use, redistribute, and copy this file is granted
// without a fee so long as as the following conditions are adhered to:
//
// o The user assumes all risk for using this software. The authors of this
//   software shall be liable for no damages of any kind.
//
// o If the source code is distributed then this copyright notice must
//   remain unaltered and any modification must be noted.
//
// o If this code is shipped in binary format the accompanying documentation
//   should state that "this software is based, in part, on the work of
//   Colosseum Builders, Inc."
//

//
//  Title:  Sample Image Viewer/Format Conversion Application
//
//  Author:  John M. Miano miano@colosseumbuilders.com
//
//----------------------------------------------------------------------------
#ifndef __PNGCONFIG_H
#define __PNGCONFIG_H
//----------------------------------------------------------------------------
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <StdCtrls.hpp>
#include <Controls.hpp>
#include <Forms.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Windows.hpp>
#include <System.hpp>

#include "pngencoder.h"
#include <ComCtrls.hpp>

//----------------------------------------------------------------------------
class TPngConfiguration : public TForm
{
__published:
  TPanel *Panel1;
  TButton *OKBtn;
  TButton *CancelBtn;
  TPageControl *PageControl1;
  TTabSheet *TabSheet1;
  TCheckBox *UseFilters;
  TEdit *BlockSize;
  TLabel *Label1;
  TComboBox *CompressionLevel;
  TLabel *Label2;
  TTabSheet *TabSheet2;
  TLabel *Label3;
  TLabel *Label4;
  TLabel *Label5;
  TLabel *Label6;
  TEdit *Title;
  TEdit *Author;
  TEdit *Description;
  TEdit *Copyright;
  TEdit *Source;
  TEdit *Comment;
  TLabel *Label7;
  TLabel *Label8;
  TCheckBox *UseAlphaChannel;
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall OKBtnClick(TObject *Sender);
private:
  Colosseum::PngEncoder *encoder ;
public:
  int ShowModal (Colosseum::PngEncoder &pe) ;
	virtual __fastcall TPngConfiguration(TComponent* AOwner);
};
//----------------------------------------------------------------------------
extern PACKAGE TPngConfiguration *PngConfiguration;
//----------------------------------------------------------------------------
#endif
