//
// Copyright (c) 1998 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// Permission to use, redistribute, and copy this file is granted
// without a fee so long as as the following conditions are adhered to:
//
// o The user assumes all risk for using this software. The authors of this
//   software shall be liable for no damages of any kind.
//
// o If the source code is distributed then this copyright notice must
//   remain unaltered and any modification must be noted.
//
// o If this code is shipped in binary format the accompanying documentation
//   should state that "this software is based, in part, on the work of
//   Colosseum Builders, Inc."
//

//
//  Title:  Sample Image Viewer/Format Conversion Application
//
//  Author:  John M. Miano miano@colosseumbuilders.com
//
//---------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "PngConfig.h"
//---------------------------------------------------------------------
#pragma resource "*.dfm"
TPngConfiguration *PngConfiguration;
//---------------------------------------------------------------------
__fastcall TPngConfiguration::TPngConfiguration(TComponent* AOwner)
	: TForm(AOwner)
{
}
//---------------------------------------------------------------------
int TPngConfiguration::ShowModal (Colosseum::PngEncoder &pe)
{
  encoder = &pe ;
  return TForm::ShowModal () ;
}

void __fastcall TPngConfiguration::FormCreate(TObject *Sender)
{
  CompressionLevel->ItemIndex = 2 ;
  return ;
}
//---------------------------------------------------------------------------

void __fastcall TPngConfiguration::OKBtnClick(TObject *Sender)
{
  int blocksize ;
  try
  {
    BlockSize->Text = BlockSize->Text.Trim () ;
    blocksize = BlockSize->Text.ToInt () ;
  }
  catch (...)
  {
    ModalResult = mrNone ;
    throw Exception ("Invalid Block Size") ;
  }
  if (blocksize < 1 || blocksize > 512000)
  {
    ModalResult = mrNone ;
    throw Exception ("Invalid Block Size") ;
  }

  encoder->setBlockSize (blocksize) ;
  encoder->setUseFilters (UseFilters->Checked) ;
  encoder->setTitle (Title->Text.c_str ()) ;
  encoder->setAuthor (Author->Text.c_str ()) ;
  encoder->setDescription (Description->Text.c_str ()) ;
  encoder->setSource (Source->Text.c_str ()) ;
  encoder->setComment (Comment->Text.c_str ()) ;
  encoder->setUseAlphaChannel (UseAlphaChannel->Checked) ;
  return ;
}
//---------------------------------------------------------------------------

