//----------------------------------------------------------------------------
#ifndef MainH
#define MainH
//
// Copyright (c) 1998 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// Permission to use, redistribute, and copy this file is granted
// without a fee so long as as the following conditions are adhered to:
//
// o The user assumes all risk for using this software. The authors of this
//   software shall be liable for no damages of any kind.
//
// o If the source code is distributed then this copyright notice must
//   remain unaltered and any modification must be noted.
//
// o If this code is shipped in binary format the accompanying documentation
//   should state that "this software is based, in part, on the work of
//   Colosseum Builders, Inc."
//

//
//  Title:  Sample Image Viewer/Format Conversion Application
//
//  Author:  John M. Miano miano@colosseumbuilders.com
//
//----------------------------------------------------------------------------
#include "ChildWin.h"
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Messages.hpp>
#include <Buttons.hpp>
#include <Dialogs.hpp>
#include <StdCtrls.hpp>
#include <Menus.hpp>
#include <Controls.hpp>
#include <Forms.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Windows.hpp>
#include <System.hpp>
#include <ToolWin.hpp>
#include <ExtDlgs.hpp>

#include "jpgencoder.h"
#include "bmpencoder.h"
#include "pngencoder.h"
//----------------------------------------------------------------------------
class TMainForm : public TForm
{
__published:
	TMainMenu *MainMenu1;
	TMenuItem *File1;
	TMenuItem *FileOpenItem;
	TMenuItem *FileCloseItem;
	TMenuItem *Window1;
	TMenuItem *Help1;
	TMenuItem *N1;
	TMenuItem *FileExitItem;
	TMenuItem *WindowCascadeItem;
	TMenuItem *WindowTileItem;
	TMenuItem *WindowArrangeItem;
	TMenuItem *HelpAboutItem;
	TOpenDialog *OpenDialog;
	TMenuItem *FileSaveAsItem;
	TMenuItem *Edit1;
	TMenuItem *CopyItem;
	TMenuItem *PasteItem;
	TMenuItem *WindowMinimizeItem;
	TStatusBar *StatusBar;
    TProgressBar *ProgressBar;
  TSpeedButton *OpenBtn;
  TSpeedButton *SaveBtn;
  TSpeedButton *CopyBtn;
  TSpeedButton *PasteBtn;
  TSpeedButton *ExitBtn;
  TPanel *Panel;
  TMenuItem *Options1;
  TMenuItem *ShowProgressive1;
  TMenuItem *N2;
  TMenuItem *GammaItem;
  TMenuItem *GrayscaleItem;
  TMenuItem *JPEGOptionsItem;
  TSaveDialog *SaveDialog;
  TMenuItem *PNGOptions1;
  TMenuItem *AlphaChannelMenu;
  TMenuItem *MergeImageMenu;
  TMenuItem *SaveMenu;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FileNewItemClick(TObject *Sender);
	void __fastcall WindowCascadeItemClick(TObject *Sender);
	void __fastcall UpdateMenuItems(TObject *Sender);
	void __fastcall WindowTileItemClick(TObject *Sender);
	void __fastcall WindowArrangeItemClick(TObject *Sender);
	void __fastcall FileCloseItemClick(TObject *Sender);
	void __fastcall FileOpenItemClick(TObject *Sender);
	void __fastcall FileExitItemClick(TObject *Sender);
	void __fastcall FileSaveItemClick(TObject *Sender);
	void __fastcall FileSaveAsItemClick(TObject *Sender);
	void __fastcall CutItemClick(TObject *Sender);
	void __fastcall CopyItemClick(TObject *Sender);
	void __fastcall PasteItemClick(TObject *Sender);
	void __fastcall WindowMinimizeItemClick(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);

	void __fastcall HelpAboutItemClick(TObject *Sender);
  void __fastcall Options1Click(TObject *Sender);
  void __fastcall ShowProgressive1Click(TObject *Sender);
  void __fastcall GammaItemClick(TObject *Sender);
  void __fastcall GrayscaleItemClick(TObject *Sender);
  void __fastcall JPEGOptionsItemClick(TObject *Sender);
  void __fastcall PNGOptions1Click(TObject *Sender);
  void __fastcall AlphaChannelMenuClick(TObject *Sender);
  void __fastcall MergeImageMenuClick(TObject *Sender);
  
  
private:
  bool show_progressive ;
  Colosseum::JpegEncoder jpeg_encoder ;
  Colosseum::PngEncoder png_encoder ;
  Colosseum::BmpEncoder bmp_encoder ;
	void __fastcall CreateMDIChild(const String Name);
	void __fastcall ShowHint(TObject *Sender);
  void __fastcall WMDropFiles (TMessage &msg) ;
BEGIN_MESSAGE_MAP
MESSAGE_HANDLER(WM_DROPFILES,TMessage,WMDropFiles)
END_MESSAGE_MAP(TForm)
public:
  void ShowProgressBar () ;
	virtual __fastcall TMainForm(TComponent *Owner);
  __property bool ShowProgressive = { read=show_progressive,
                                         write=show_progressive } ;
};
//----------------------------------------------------------------------------
extern TMainForm *MainForm;
extern TMDIChild *__fastcall MDIChildCreate(void);
//----------------------------------------------------------------------------
#endif
