//
// Copyright (c) 1998 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// Permission to use, redistribute, and copy this file is granted
// without a fee so long as as the following conditions are adhered to:
//
// o The user assumes all risk for using this software. The authors of this
//   software shall be liable for no damages of any kind.
//
// o If the source code is distributed then this copyright notice must
//   remain unaltered and any modification must be noted.
//
// o If this code is shipped in binary format the accompanying documentation
//   should state that "this software is based, in part, on the work of
//   Colosseum Builders, Inc."
//

//
//  Title:  Sample Image Viewer/Format Conversion Application
//
//  Author:  John M. Miano miano@colosseumbuilders.com
//
//----------------------------------------------------------------------------
#ifndef JpegConfigH
#define JpegConfigH
//----------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Windows.hpp>
#include <Messages.hpp>
#include <Classes.hpp>
#include <Graphics.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>

#include "jpgencoder.h"
//----------------------------------------------------------------------------
class TJPEGOptions : public TForm
{
__published:
  TPageControl *PageControl;
  TPanel *Panel1;
  TButton *OkButton;
  TButton *CancelButton;
  TTabSheet *SequentialSheet;
  TTabSheet *ProgressiveSheet;
  TTabSheet *SamplingSheet;
  TGroupBox *GroupBox1;
  TRadioButton *YV1;
  TRadioButton *YV2;
  TRadioButton *YV3;
  TRadioButton *YV4;
  TGroupBox *GroupBox2;
  TRadioButton *YH1;
  TRadioButton *YH2;
  TRadioButton *YH3;
  TRadioButton *YH4;
  TGroupBox *GroupBox3;
  TRadioButton *CbH1;
  TRadioButton *CbH2;
  TRadioButton *CbH3;
  TRadioButton *CbH4;
  TGroupBox *GroupBox4;
  TRadioButton *CbV1;
  TRadioButton *CbV2;
  TRadioButton *CbV3;
  TRadioButton *CbV4;
  TLabel *Label1;
  TLabel *Label2;
  TLabel *Label3;
  TGroupBox *GroupBox5;
  TRadioButton *CrH1;
  TRadioButton *CrH2;
  TRadioButton *CrH3;
  TRadioButton *CrH4;
  TGroupBox *GroupBox6;
  TRadioButton *CrV1;
  TRadioButton *CrV2;
  TRadioButton *CrV3;
  TRadioButton *CrV4;
  TLabel *Label4;
  TLabel *Label5;
  TEdit *SS2;
  TEdit *SS3;
  TEdit *SS4;
  TEdit *SS5;
  TEdit *SS6;
  TEdit *SA6;
  TEdit *SA1;
  TEdit *SA2;
  TEdit *SA3;
  TEdit *SA4;
  TEdit *SA5;
  TEdit *SA7;
  TLabel *Label6;
  TLabel *Label7;
  TLabel *Label8;
  TLabel *Label9;
  TLabel *Label10;
  TLabel *Label11;
  TLabel *Label12;
  TLabel *Label13;
  TLabel *Label14;
  TPanel *Panel2;
  TRadioButton *SequentialButton;
  TRadioButton *ProgresiveButton ;
  TPanel *Panel4;
  TPanel *Panel5;
  TPanel *Panel6;
  TLabel *Label15;
  TLabel *Label16;
  TLabel *Label17;
  TLabel *Label18;
  TLabel *Label19;
  TRadioButton *Scan1Y;
  TRadioButton *Scan2Y;
  TRadioButton *Scan3Y;
  TRadioButton *Scan1Cb;
  TRadioButton *Scan2Cb;
  TRadioButton *Scan3Cb;
  TRadioButton *Scan1Cr;
  TRadioButton *Scan2Cr;
  TRadioButton *Scan3Cr;
  TLabel *Label20;
  TEdit *QualityValue;
  TLabel *Label21;
  TCheckBox *Grayscale;
  void __fastcall SequentialButtonClick(TObject *Sender);
  void __fastcall ProgresiveButtonClick(TObject *Sender);

  void __fastcall OkButtonClick(TObject *Sender);
private:
  Colosseum::JpegEncoder *encoder ;
public:
  int ShowModal (Colosseum::JpegEncoder &je) ;
  void WriteSettings (Colosseum::JpegEncoder &) ;
	virtual __fastcall TJPEGOptions(TComponent *Owner);
};
//----------------------------------------------------------------------------
extern PACKAGE TJPEGOptions *JPEGOptions;
//----------------------------------------------------------------------------
#endif
