//
// Copyright (c) 1998 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// Permission to use, redistribute, and copy this file is granted
// without a fee so long as as the following conditions are adhered to:
//
// o The user assumes all risk for using this software. The authors of this
//   software shall be liable for no damages of any kind.
//
// o If the source code is distributed then this copyright notice must
//   remain unaltered and any modification must be noted.
//
// o If this code is shipped in binary format the accompanying documentation
//   should state that "this software is based, in part, on the work of
//   Colosseum Builders, Inc."
//

//
//  Title:  Sample Image Viewer/Format Conversion Application
//
//  Author:  John M. Miano miano@colosseumbuilders.com
//
//----------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "JpegConfig.h"
//----------------------------------------------------------------------------
#pragma resource "*.dfm"
TJPEGOptions *JPEGOptions;
//----------------------------------------------------------------------------
__fastcall TJPEGOptions::TJPEGOptions(TComponent *Owner)
	: TForm(Owner)
{
}
//----------------------------------------------------------------------------
void __fastcall TJPEGOptions::SequentialButtonClick(TObject *Sender)
{
  SequentialSheet->TabVisible = true ;
  ProgressiveSheet->TabVisible = false ;
  if (PageControl->ActivePage == ProgressiveSheet)
    PageControl->ActivePage = SequentialSheet ;
  return ;
}
//---------------------------------------------------------------------------

void __fastcall TJPEGOptions::ProgresiveButtonClick(TObject *Sender)
{
  ProgressiveSheet->TabVisible = true ;
  SequentialSheet->TabVisible = false ;
  if (PageControl->ActivePage == SequentialSheet)
    PageControl->ActivePage = ProgressiveSheet ;
  return ;
}
//---------------------------------------------------------------------------

void TJPEGOptions::WriteSettings (Colosseum::JpegEncoder &encoder)
{
  int quality ;
  QualityValue->Text = QualityValue->Text.Trim () ;
  try
  {
    quality = QualityValue->Text.ToInt () ;
  }
  catch (...)
  {
    throw Exception ("Invalid Quality Value") ;
  }
  if (quality < 1 || quality > 100)
    throw Exception ("Invalid Quality Value") ;

  TEdit *sss [5] = { SS2, SS3, SS4, SS5, SS6 } ;
  TEdit *ssa [7] = { SA1, SA2, SA3, SA4, SA5, SA6, SA7 } ;
  unsigned int ssv [7] ;
  unsigned int sav [7] ;
  if (SequentialButton->Checked)
  {
    encoder.setProgressive (false) ;
  }
  else
  {
    int last = 0 ;
    ssv [0] = 0 ;
    ssv [6] = 63 ;
    for (unsigned int ii = 0 ; ii < 5 ; ++ ii)
    {
      if (last == 63)
      {
        sss [ii]->Text = "" ;
      }
      else
      {
        String sv = sss [ii]->Text.Trim () ;
        sss [ii]->Text = sv ;
        int iv ;
        try
        {
          iv = sv.ToInt () ;
        }
        catch (...)
        {
          ModalResult = mrNone ;
          throw ;
        }
        if (iv <= last || iv > 63)
        {
          sss [ii]->SetFocus () ;
          ModalResult = mrNone ;
          throw Exception ("Invalid Spectral Range") ;
        }
        last = iv ;
        ssv [ii + 1] = iv ;
      }
    }
    for (unsigned int ii = 0 ; ii < 7 ; ++ ii)
    {
      String sv = ssa [ii]->Text.Trim () ;
      ssa [ii]->Text = sv ;

      int iv ;
      try
      {
        iv = sv.ToInt () ;
      }
      catch (...)
      {
        ModalResult = mrNone ;
        throw ;
      }
      if (iv > 13 || iv < 0)
      {
        ModalResult = mrNone ;
        throw Exception ("Invalid Successive Approximation") ;
      }
      sav [ii] = iv ;
    }
  }

  if (SequentialButton->Checked)
  {
    encoder.setProgressive (false) ;
    int one = 0, two = 0, three = 0 ;
    if (Scan1Y->Checked)
      one = 1 << 1 ;
    else if (Scan2Y->Checked)
      two = 1 << 1 ;
    else
      three = 1 << 1 ;
    if (Scan1Cb->Checked)
      one |= 1 << 2 ;
    else if (Scan2Cb->Checked)
      two |= 1 << 2 ;
    else
      three |= 1 << 2 ;
    if (Scan1Cr->Checked)
      one |= 1 << 3 ;
    else if (Scan2Cr->Checked)
      two |= 1 << 3 ;
    else
      three |= 1 << 3 ;

    encoder.setScanAttributes (0, one, 0, 0) ;
    encoder.setScanAttributes (1, two, 0, 0) ;
    encoder.setScanAttributes (2, three, 0, 0) ;
  }
  else
  {
    encoder.setProgressive (true) ;
    for (unsigned int ii = 0 ; ii < 7 ; ++ ii)
    {
      encoder.setScanAttributes (3*ii, 1 << 1, ssv [ii], sav [ii]) ;
      encoder.setScanAttributes (3*ii+1, 1 << 2, ssv [ii], sav [ii]) ;
      encoder.setScanAttributes (3*ii+2, 1 << 3, ssv [ii], sav [ii]) ;
      if (ssv [ii] == 63)
        break ;
    }
  }
  encoder.setQuality (quality) ;
  encoder.setGrayscale (Grayscale->Checked) ;
  return ;
}

int TJPEGOptions::ShowModal (Colosseum::JpegEncoder &je)
{
  encoder = &je ;
  return TForm::ShowModal () ;
}

void __fastcall TJPEGOptions::OkButtonClick(TObject *Sender)
{
  WriteSettings (*encoder) ;
  return ;
}
//---------------------------------------------------------------------------

