//
// Copyright (c) 1998 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// Permission to use, redistribute, and copy this file is granted
// without a fee so long as as the following conditions are adhered to:
//
// o The user assumes all risk for using this software. The authors of this
//   software shall be liable for no damages of any kind.
//
// o If the source code is distributed then this copyright notice must
//   remain unaltered and any modification must be noted.
//
// o If this code is shipped in binary format the accompanying documentation
//   should state that "this software is based, in part, on the work of
//   Colosseum Builders, Inc."
//

//
//  Title:  Sample Image Viewer/Format Conversion Application
//
//  Author:  John M. Miano miano@colosseumbuilders.com
//
#include "EditableBitmap.h"

#include <math.h>
#include "bitmapimage.h"
#include "jfif.h"

using namespace Colosseum ;

const double MaxColor = 255.0 ;

EditableBitmapImage &EditableBitmapImage::operator=(
                                   const Colosseum::BitmapImage &source)
{
  Colosseum::BitmapImage::operator=(source) ;
  return *this ;
}

void EditableBitmapImage::GammaCorrect (double gamma)
{
  BitmapImage::Pixel *pixel = &(*this) [0] ;
  for (unsigned int ii = 0 ; ii < getHeight () * getWidth () ; ++ ii)
  {
    pixel [ii].red = MaxColor * exp (gamma * log (pixel [ii].red/MaxColor)) ;
    pixel [ii].green = MaxColor * exp (gamma * log (pixel [ii].green/MaxColor)) ;
    pixel [ii].blue = MaxColor * exp (gamma * log (pixel [ii].blue/MaxColor)) ;
  }
  return ;
}

void EditableBitmapImage::ToGrayscale ()
{
  BitmapImage::Pixel *pixel = &(*this) [0] ;
  for (unsigned int ii = 0 ; ii < getHeight () * getWidth () ; ++ ii)
  {
    unsigned int value = ColosseumPrivate::RgbToY (pixel [ii].red, pixel [ii].green, pixel [ii].blue) ;
    pixel [ii].red = pixel [ii].green = pixel [ii].blue = value ;
  }
  return ;
}

