//----------------------------------------------------------------------------
#ifndef ChildWinH
#define ChildWinH
//
// Copyright (c) 1998 Colosseum Builders, Inc.
// All rights reserved.
//
// Colosseum Builders, Inc. makes no warranty, expressed or implied
// with regards to this software. It is provided as is.
//
// Permission to use, redistribute, and copy this file is granted
// without a fee so long as as the following conditions are adhered to:
//
// o The user assumes all risk for using this software. The authors of this
//   software shall be liable for no damages of any kind.
//
// o If the source code is distributed then this copyright notice must
//   remain unaltered and any modification must be noted.
//
// o If this code is shipped in binary format the accompanying documentation
//   should state that "this software is based, in part, on the work of
//   Colosseum Builders, Inc."
//

//
//  Title:  Sample Image Viewer/Format Conversion Application
//
//  Author:  John M. Miano miano@colosseumbuilders.com
//
//----------------------------------------------------------------------------
#include <Controls.hpp>
#include <Forms.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <Windows.hpp>
#include <System.hpp>
#include <ExtCtrls.hpp>

#include "EditableBitmap.h"
#include "imagetype.h"

//----------------------------------------------------------------------------
class TMDIChild : public TForm
{
__published:
  TPaintBox *PaintBox;
  void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
  void __fastcall PaintBoxPaint(TObject *Sender);

  
private:
  void LoadBitmapInfoHeader () ;

  EditableBitmapImage image ;
  Colosseum::ImageType image_type ;
  BITMAPV4HEADER image_header ;
  double gamma_value ;
  void __fastcall SetGammaValue (double) ;
  bool is_busy ;
public:
  void ReadImage (const String &) ;
  Colosseum::ImageType GetImageType () { return image_type ; }
	virtual __fastcall TMDIChild(TComponent *Owner);
  void Grayscale () ;
  void CopyToClipboard () ;
  void CopyFromClipboard () ;
  void SetAlpha (unsigned int value) ;
  void MergeImage (const String &file) ;

  Colosseum::BitmapImage &GetImage () { return image ; }
  friend void ProgressFunction (Colosseum::BitmapImageCoder &coder,
                              void *data,
                              unsigned int currentpass,
                              unsigned int passcount,
                              unsigned int progress,
                              bool &cancel) ;
  __property double GammaValue = { read=gamma_value, write=SetGammaValue } ;
};
//----------------------------------------------------------------------------
#endif
