unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, THASP;

type
  TMainFrm = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    RefreshBtn: TButton;
    HighPwdGet: TEdit;
    LowPwdGet: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    ConnectedChk: TCheckBox;
    PortCmb: TComboBox;
    Label4: TLabel;
    KeyTypeCmb: TComboBox;
    CachedChk: TCheckBox;
    Bevel2: TBevel;
    Label5: TLabel;
    Seed2Get: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Value1Get: TEdit;
    EncodeIntBtn: TButton;
    EncodeStrBtn: TButton;
    HASP: TTimeHASP;
    ResultsMem: TMemo;
    ExitBtn: TButton;
    Label10: TLabel;
    MemSizeGet: TEdit;
    GetHASPCodeBtn: TButton;
    Bevel3: TBevel;
    Label11: TLabel;
    Seed1Get: TEdit;
    Label12: TLabel;
    Bevel4: TBevel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    AddressGet: TEdit;
    Value2Get: TEdit;
    ReadWordBtn: TButton;
    WriteWordBtn: TButton;
    ReadStrBtn: TButton;
    WriteStrBtn: TButton;
    ValueLenGet: TEdit;
    Label16: TLabel;
    Bevel5: TBevel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    DateGet: TEdit;
    TimeGet: TEdit;
    GetBtn: TButton;
    SetBtn: TButton;
    RegisterBtn: TButton;
    HelpBtn: TButton;
    procedure RefreshBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure CachedChkClick(Sender: TObject);
    procedure GetHASPCodeBtnClick(Sender: TObject);
    procedure EncodeIntBtnClick(Sender: TObject);
    procedure EncodeStrBtnClick(Sender: TObject);
    procedure ReadWordBtnClick(Sender: TObject);
    procedure WriteWordBtnClick(Sender: TObject);
    procedure ReadStrBtnClick(Sender: TObject);
    procedure WriteStrBtnClick(Sender: TObject);
    procedure GetBtnClick(Sender: TObject);
    procedure SetBtnClick(Sender: TObject);
    procedure KeyChange(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure RegisterBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure RefreshControls;
    procedure EnableButtons;
    function  HelpFileName : String;
  public
    { Public declarations }
  end;

var
  MainFrm: TMainFrm;

implementation

{$R *.DFM}
{=======================}
procedure TMainFrm.RefreshControls;
begin
  With HASP do
    begin
    Cached       := CachedChk.Checked;
    Refresh;
    KeyTypeCmb.ItemIndex := Ord(HASPType);
    ConnectedChk.Checked := Connected;
    MemSizeGet.Text      := IntToStr(HASP.MemorySize);
    Case Port of
    102 : PortCmb.ItemIndex :=  0;
    103 : PortCmb.ItemIndex :=  1;
    104 : PortCmb.ItemIndex :=  2;
    else  PortCmb.ItemIndex := -1;
    end;
    EnableButtons;
    end;
end;
{=======================}
procedure TMainFrm.RefreshBtnClick(Sender: TObject);
begin
  With HASP do
    begin
    LowPassword  := StrToInt(LowPwdGet.Text);
    HighPassword := StrToInt(HighPwdGet.Text);
    end;
  RefreshControls;
end;
{=======================}
procedure TMainFrm.ExitBtnClick(Sender: TObject);
begin
  HASP.Close;
  Application.Terminate;
end;
{=======================}
procedure TMainFrm.CachedChkClick(Sender: TObject);
begin
  With CachedChk do
    begin
    KeyTypeCmb.Enabled   := Checked;
    ConnectedChk.Enabled := Checked;
    PortCmb.Enabled      := Checked;
    MemSizeGet.Enabled   := Checked;
    end;
  RefreshControls;
end;
{=======================}
procedure TMainFrm.GetHASPCodeBtnClick(Sender: TObject);
var i1, i2, i3, i4 : LongInt;
begin
  HASP.GetHASPCode(StrToInt(Seed1Get.Text), i1, i2, i3, i4);
  With ResultsMem.Lines do
    begin
    Clear;
    Add('Result #1 = ' + IntToStr(i1));
    Add('Result #2 = ' + IntToStr(i2));
    Add('Result #3 = ' + IntToStr(i3));
    Add('Result #4 = ' + IntToStr(i4));
    end;
end;
{=======================}
procedure TMainFrm.EncodeIntBtnClick(Sender: TObject);
begin
  Value1Get.Text := IntToStr(HASP.EncodeInteger(StrToInt(Seed2Get.Text), StrToInt(Value1Get.Text)));
  If ((Sender as TButton).Caption = 'Encode &integer') then
    (Sender as TButton).Caption  := 'Decode &integer'
  else
    (Sender as TButton).Caption  := 'Encode &integer';
end;
{=======================}
procedure TMainFrm.EncodeStrBtnClick(Sender: TObject);
begin
  Value1Get.Text := HASP.EncodeString(StrToInt(Seed2Get.Text), Value1Get.Text);
  If ((Sender as TButton).Caption = 'Encode &string') then
    (Sender as TButton).Caption  := 'Decode &string'
  else
    (Sender as TButton).Caption  := 'Encode &string';
end;
{=======================}
procedure TMainFrm.ReadWordBtnClick(Sender: TObject);
var iWord : LongInt;
begin
  HASP.ReadWord(StrToInt(AddressGet.Text), iWord);
  Value2Get.Text := IntToStr(iWord);
end;
{=======================}
procedure TMainFrm.WriteWordBtnClick(Sender: TObject);
begin
  HASP.WriteWord(StrToInt(AddressGet.Text), StrToInt(Value2Get.Text));
end;
{=======================}
procedure TMainFrm.ReadStrBtnClick(Sender: TObject);
begin
  Value2Get.Text := HASP.ReadString(StrToInt(AddressGet.Text), StrToInt(ValueLenGet.Text));
end;
{=======================}
procedure TMainFrm.WriteStrBtnClick(Sender: TObject);
begin
  HASP.WriteString(StrToInt(AddressGet.Text), Value2Get.Text);
end;
{=======================}
procedure TMainFrm.GetBtnClick(Sender: TObject);
begin
  DateGet.Text := DateToStr(HASP.GetDate);
  TimeGet.Text := TimeToStr(HASP.GetTime);
end;
{=======================}
procedure TMainFrm.SetBtnClick(Sender: TObject);
begin
  HASP.SetDate(StrToDate(DateGet.Text));
  HASP.SetTime(StrToTime(TimeGet.Text));
end;
{=======================}
procedure TMainFrm.KeyChange(Sender: TObject);
begin
  EnableButtons;
end;
{=======================}
procedure TMainFrm.EnableButtons;
var iMemSize : Integer;
begin
  try    iMemSize := StrToInt(MemSizeGet.Text);
  except iMemSize := 0;
  end;

  GetHASPCodeBtn.Enabled :=  ConnectedChk.Checked;
  EncodeIntBtn.Enabled   :=  ConnectedChk.Checked;
  EncodeStrBtn.Enabled   :=  ConnectedChk.Checked;

  ReadWordBtn.Enabled    := (iMemSize > 0) and (ConnectedChk.Checked);
  WriteWordBtn.Enabled   := (iMemSize > 0) and (ConnectedChk.Checked);
  ReadStrBtn.Enabled     := (iMemSize > 0) and (ConnectedChk.Checked);
  WriteStrBtn.Enabled    := (iMemSize > 0) and (ConnectedChk.Checked);

  GetBtn.Enabled := ((KeyTypeCmb.Text = 'TimeHASP') or (KeyTypeCmb.Text = 'TimeHASP4')) and (ConnectedChk.Checked);
  SetBtn.Enabled := ((KeyTypeCmb.Text = 'TimeHASP') or (KeyTypeCmb.Text = 'TimeHASP4')) and (ConnectedChk.Checked);
end;
{=======================}
function TMainFrm.HelpFileName : String;
begin
  Result := ExtractFilePath(Application.ExeName);
  If (Result[Length(Result)] = '\') then
    Result := Result + 'hasp.hlp'
  else
    Result := Result + '\hasp.hlp';
end;
{=======================}
procedure TMainFrm.HelpBtnClick(Sender: TObject);
begin
  If (FileExists(HelpFileName)) then
    Application.HelpCommand(HELP_FINDER, 0)
  else
    MessageDlg('Please put the HASP.HLP and HASP.CNT files into the current project directory', mtInformation, [mbOK], 0);
end;
{=======================}
procedure TMainFrm.RegisterBtnClick(Sender: TObject);
var pczHelpFile : PChar;
begin
  If (FileExists(HelpFileName)) then
    begin
    GetMem(pczHelpFile, Length('HASP.HLP')+1);
    StrPCopy(pczHelpFile, 'HASP.HLP');
    WinHelp(Handle, pczHelpFile, HELP_CONTEXT, 34);
    FreeMem(pczHelpFile, Length('HASP.HLP')+1);
    end
  else
    MessageDlg('Please put the HASP.HLP and HASP.CNT files into the current project directory', mtInformation, [mbOK], 0);
end;
{=======================}
procedure TMainFrm.FormCreate(Sender: TObject);
begin
  If (FindWindow('TAppBuilder', Nil) = 0) then
    MessageDlg('Attention! If you have not registered the Delphi HASP Components package, this software will not work properly without Delphi running.',
                mtInformation, [mbOK, mbHelp], 34);
end;
{=======================}
end.
