#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "gnuregex.h"

/////////////////////////////////////////////////////////////////	

static char * szProgram;

/////////////////////////////////////////////////////////////////	

void error(const char * szMessage, int iError)
{
	if (iError)
	{
		fprintf(stderr, "%s: %s: %s\n",
			szProgram,
			szMessage,
			strerror(iError));
	}
	else
	{
		fprintf(stderr, "%s: %s\n",
			szProgram,
			szMessage);
	}
}

/////////////////////////////////////////////////////////////////	

int main(int argc, char * argv[])
{
	szProgram = argv[0];

	{
		regex_t reg;
		regmatch_t match;

		char * pchErrorMessage;
		int iReturn;
		unsigned long uliLength;

		if (argc != 3)
		{
			error("Wrong number of parameters", 0);
			return 1;
		}

		if ((iReturn = regcomp(&reg, argv[1], 0)) != 0)
		{
			// Allocate space for an error message
			uliLength = regerror(iReturn, &reg, NULL, 0);
			pchErrorMessage = (char *)malloc(uliLength);

			// Retrieve and display the error message
			(void)regerror(iReturn, &reg, pchErrorMessage, uliLength);
			error(pchErrorMessage, 0);

			free(pchErrorMessage);
			return 1;
		}

		if (regexec(&reg, argv[2], 1, &match, 0) != 0)
		{
			// Allocate space for an error message
			uliLength = regerror(iReturn, &reg, NULL, 0);
			pchErrorMessage = (char *)malloc(uliLength);

			// Retrieve and display the error message
			(void)regerror(iReturn, &reg, pchErrorMessage, uliLength);
			error(pchErrorMessage, 0);

			free(pchErrorMessage);
			return 1;
		}

		printf("\"%s\" found in \"%s\" at location %d.\n",
			argv[1],
			argv[2],
			match.rm_so);

		regfree(&reg);
	}

	// Now, let's try the non-POSIX stuff.
	{
		struct re_registers registers;
		struct re_pattern_buffer patbuf;

		const char * pchError;
		int iReturn;
		unsigned long uliLength;

		// Clear that puppy out before starting.
		memset(&patbuf, 0, sizeof(patbuf));

		if ((pchError = re_compile_pattern(argv[1], strlen(argv[1]), &patbuf)) != NULL)
		{
			error(pchError, 0);
			return 1;
		}

		uliLength = strlen(argv[2]);
		if ((iReturn = re_search(&patbuf, argv[2], uliLength, 0, uliLength, &registers)) == -1)
		{
			error("Not found.", 0);
			return 1;
		}
		else if (iReturn == -2)
		{
			error("re_search failed.", errno);
			return 1;
		}

		printf("\"%s\" found in \"%s\" at location %d.\n",
			argv[1],
			argv[2],
			iReturn);

		// This is a nasty ol' kludge to avoid a bug in the Microsoft
		// C libraries.

		gnuregex_free(patbuf.buffer);
		gnuregex_free(registers.start);
		gnuregex_free(registers.end);
	}

	return 0;
}

/////////////////////////////////////////////////////////////////	
