; -----------------------------------------------------------------------------
; PMMOUSE.ASM	Sample Protected Mode Mouse Event Handler	  Version 1.00
;
; Copyright(c) 1995 by B-coolWare.  Written by Bobby Z.
; -----------------------------------------------------------------------------

	MODEL	X,PASCAL	; replace X with appropriate model, or
				; do not use MODEL at all
	.CODE

RMRegs	struc
	_EDI	dd	?
	_ESI	dd	?
	_EBP	dd	?
	_Res	dd	?
	_EBX	dd	?
	_EDX	dd	?
	_ECX	dd	?
	_EAX	dd	?
	_Flags	dw	?
	_ES	dw	?
	_DS	dw	?
	_FS	dw	?
	_GS	dw	?
	_IP	dw	?
	_CS	dw	?
	_SP	dw	?
	_SS	dw	?
	ends

Regs		RMRegs	<>
callback	dd	?
cs_alias	dw	?
__data		dw	?

_bp	equ	<byte ptr>
_wp	equ	<word ptr>
_dp	equ	<dword ptr>

MouseEventsAll	equ	007Fh	; events to track
MouseEventsNone	equ	0000h


MouseHandler:
; this is a callback procedure called from real mode callback address.
; on entry:
;
; DS:SI -> real mode stack
; ES:DI -> real mode call structure
; SS:SP -> locked protected mode API stack

	mov	ax,_wp es:RMRegs[di]._eax
	mov	bx,_wp es:RMRegs[di]._ebx
	mov	cx,_wp es:RMRegs[di]._ecx
	mov	dx,_wp es:RMRegs[di]._edx
	push	ds
	push	cs:__data	; set DS to point to our data segment
	pop	ds
; ---------------------------------------------------------

; now we can operate with GP registers as if we are in real mode.
; do what you want with them, set any flags and variables in data segment, etc.
; be sure to preserve ES, SI and DI

; ---------------------------------------------------------
	pop	ds
	lodsw
	mov	es:RMRegs[di]._ip,ax	; get real mode return address from
	lodsw				; real mode stack and set up the
	mov	es:RMRegs[di]._cs,ax	; RM call structure
	add	es:RMRegs[di]._sp,4	; adjust real mode stack

	; we can modify all other registers in real mode call structure, but
	; this won't have any effect, for mouse driver always preserves all
	; registers before calling the handler.

	iret				; we MUST return with IRET
					; and es:di MUST point to the real mode
					; structure.

grabMouse	proc
; this routine actually installs mouse handler.
; On entry:
;
; DS = program data segment
;
	push	ds		; save current DS

	mov	ax,000Ah	; create a writeable code segment alias
	mov	bx,cs		; to store data in
	int	31h
	jc	@@error
	mov	es,ax
	mov	es:__data,ds	; save data segment for future reference

	mov	ds,ax		; ds now points to the same segment as cs but
				; with write access
	mov	ax,0303h	; setup the callback
	push	ds
	push	ds
	mov	bx,cs
	mov	ds,bx
	mov	si,offset MouseHandler
	pop	es		; ds:si -> PM procedure address
	mov	di,offset Regs	; es:di -> real mode call structure
	int	31h
	pop	ds
	jc	@@error
	; cx:dx -> real mode callback address
	mov	_wp ds:callback,dx	; save the address for future use
	mov	_wp ds:callback[2],cx
	
	mov	_wp ds:Regs._eax,0Ch	; set mouse event handler function
	mov	_wp ds:Regs._ecx,MouseEventsAll
	mov	ds:Regs._es,cx		; es:dx -> event handler (actually it
	mov	_wp ds:Regs._edx,dx	; is our callback address)
	mov	_wp ds:Regs._Flags,0	; all flags zeroed
	mov	ax,0300h		; simulate real mode interrupt
	mov	bx,0033h		; INT 33h
	sub	cx,cx			; no stack parameters
	push	ds			; es:di -> real mode call structure
	pop	es
	mov	di,offset Regs
	int	31h
	; finita la comedia
	mov	ax,ds
	mov	ds:cs_alias,ax		; save the alias segment
@@error:				; CF set on error, clear otherwise
	pop	ds			; restore DS
	ret
	endp

freeMouse	proc
; this routine deinstalls mouse handler and cleans up LDT
	push	ds		; save current DS
	mov	ax,cs:cs_alias
	mov	ds,ax
	mov	_wp ds:Regs._eax,0Ch
	mov	_wp ds:Regs._ecx,MouseEventsNone
	mov	ds:Regs._Flags,0
	mov	ax,0300h
	mov	bx,0033h
	sub	cx,cx
	push	ds
	pop	es
	mov	di,offset Regs
	int	31h			; this call will effectively disable
					; the real mode mouse handler

	mov	dx,_wp ds:callback
	mov	cx,_wp ds:callback[2]
	mov	ax,0304h
	int	31h			; free the callback
	mov	bx,ds
	mov	ax,0001h
	int	31h			; free the alias descriptor
	pop	ds
	ret
	endp

	END
