{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{$M 16384,0,655360}

{ --------------------------------------------------------------------------- }
{ GMDEMO.PAS  Sample program demonstrating usage of gMouse unit.              }
{                                                                             }
{ Copyright(c) 1995 by B-coolWare.  Written by Bobby Z.                       }
{ Fonts by Wasil Melnichuk of 2:463/22.44@fidonet                             }
{ --------------------------------------------------------------------------- }

uses g_Mouse, Crt;

function stUpcase( S : String ) : String; assembler;
asm
        les     di,@Result
        push    ds
        lds     si,S
        cld
        lodsb
        mov     cl,al
        sub     ch,ch
        stosb
        jcxz    @@Q
@@1:
        lodsb
        cmp     al,'a'
        jb      @@2
        cmp     al,'z'
        ja      @@2
        and     al,0DFh
        stosb
@@2:
        loop    @@1
@@Q:
        pop     ds
end;

{$I SHAPES.INC}

procedure Normal16; external;
{$L NORMAL16}

procedure Shadow16; external;
{$L SHADOW16}

type
        TByteArray = array[0..$FFF0] of Byte;
        PByteArray = ^TByteArray;

Procedure LoadFonts;
 var P:PByteArray;
     i: Byte;

 begin
    P:=@Normal16;
    for i := 0 to 255 do
     begin
      SelectFontBank(0);
      SetCharBitmap(i,P^[i*16]);
     end;

    P:=@Shadow16;
    for i := 0 to 255 do
     begin
      SelectFontBank(1);
      SetCharBitmap(i,P^[i*16]);
     end;
 SetDisplayableFonts(0,1);
 end;

procedure WriteXY( S : String; X,Y, Attr : Byte ); assembler;
asm
        push    ds
        push    SegB800
        pop     es
        lds     si,S
        mov     ax,160
        mul     Y
        mov     bl,X
        sub     bh,bh
        shl     bx,1
        add     ax,bx
        mov     di,ax
        mov     ah,Attr
        lodsb
        mov     cl,al
        sub     ch,ch
        jcxz    @@Q
@@1:
        lodsb
        stosw
        loop    @@1
@@Q:
        pop     ds
end;

const
        doFlip : Boolean = True;

var
        SaveANDMask,
        SaveORMask  : array[0..15] of Byte;

begin
 ClrScr;
 WriteLn('g_Mouse Demo  Version 1.54.7  Copyright(c) 1993-99 by B-coolWare.');
 WriteLn;
 WriteLn('Move mouse around and enjoy the pointer. Press a key to exit...');
 Set30Lines;
 if ParamCount > 0 then
  if stUpcase(ParamStr(1)) = 'NOFLIP' then
   doFlip := False;
 InitGMouse(doFlip);
 { normally, one would like to save current font in some buffer, but I don't
   want to bother with it. Instead I reinitialize video mode at the end of this
   program. }
 LoadFonts;
 WriteXY('This is font #0: ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',2,5,7);
 WriteXY('This is font #1: ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',2,6,$F);
 setFontMode(True,0,1);
 GetPointerShape(SaveANDMask, SaveORMask);
 SetPointerShape(SandClockANDMask, SandClockORMask);
 asm
    mov  ax,1
    int  33h
 end;
 repeat
 until KeyPressed;
 ReadKey;
 SetPointerShape(SaveANDMask, SaveORMask);
 repeat
 until KeyPressed;
 ReadKey;
 asm
     mov    ax,2
     int    33h
     mov    ax,3
     int    10h
 end;
end.
