{: Demo Program for GpTimeZone by Primoz Gabrijelcic}
unit testUTC1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Spin;

type
  TfrmMain = class(TForm)
    lvTZ: TListView;
    grpTimezone: TGroupBox;
    Label2: TLabel;
    outStandard: TMemo;
    Label1: TLabel;
    outDaylight: TMemo;
    dateLocal: TDateTimePicker;
    timeLocal: TDateTimePicker;
    dateUTC: TDateTimePicker;
    timeUTC: TDateTimePicker;
    Label3: TLabel;
    Label4: TLabel;
    outInvalidTime: TEdit;
    btnLocD2S: TButton;
    btnLocS2D: TButton;
    dateUTC2: TDateTimePicker;
    timeUTC2: TDateTimePicker;
    dateSwatch: TDateTimePicker;
    lblSwatchHead: TLabel;
    timeSwatch: TSpinEdit;
    lblSwatch: TLabel;
    dateSwatch2: TDateTimePicker;
    lblSwatch2: TLabel;
    timeSwatch2: TSpinEdit;
    btnLocNow: TButton;
    outUTCBias: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure lvTZCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure dateLocalChange(Sender: TObject);
    procedure btnLocD2SClick(Sender: TObject);
    procedure timeUTC2Change(Sender: TObject);
    procedure lvTZClick(Sender: TObject);
  private
    UTC2    : TDateTime;
    Swatch2 : TDateTime;
    changing: boolean;
    initDate: boolean;
    procedure LoadTimeZones; 
  public
  end;

var
  frmMain: TfrmMain;

implementation

uses
  gpTimezone;

{$R *.DFM}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  initDate := true;
  LoadTimeZones;
end; { TfrmMain.FormCreate }

procedure TfrmMain.LoadTimeZones;
var
  p    : integer;
  TZ   : TTimeZoneInformation;
  curTZ: TTimeZoneInformation;
  eng  : string;
  disp : string;
  i    : integer;
  sign : string;
begin
  lvTZ.Items.Clear;
  if GetTimeZoneInformation(curTZ) = DWORD($FFFFFFFF) then FillChar(curTZ,SizeOf(curTZ),0);
  for i := 0 to GetTZCount-1 do begin
    if GetTZ(i,eng,disp,TZ) then begin
      with lvTZ.Items.Add do begin
        Data := pointer(-TZ.bias);
        if TZ.bias = 0 then Caption := ''
        else begin
          if TZ.bias < 0
            then sign := '+'
            else sign := '-';
          Caption := Format('%s%.2d:%.2d',[sign,Abs(TZ.bias) div 60,Abs(TZ.bias) mod 60]);
        end;
        if (disp <> '') and (disp[1] = '(') then begin
          // strip (GMT+xx:xx) prefix
          p := Pos(')',disp);
          if p > 0 then System.Delete(disp,1,p);
          while (disp <> '') and (disp[1] = ' ') do System.Delete(disp,1,1);
        end;
        Subitems.Add(eng);
        if IsEqualTZ(TZ,curTZ)
          then Subitems.Add('H') // home time zone
          else Subitems.Add('');
        Subitems.Add(IntToStr(i));
      end; //with
    end;
  end; //for
  // select home time zone
  for i := 0 to lvTZ.Items.Count - 1 do begin
    if lvTZ.Items[i].Subitems[1] <> '' then begin
      lvTZ.Items[i].Selected := true;
      lvTZ.Items[i].MakeVisible(false);
      break;
    end;
  end; //for
  lvTZ.OnCLick(lvTZ);
end; { TfrmMain.LoadTimeZones }

procedure TfrmMain.lvTZCompare(Sender: TObject; Item1, Item2: TListItem;
  Data: Integer; var Compare: Integer);
begin
  if longint(Item1.Data) < longint(Item2.Data)
    then Compare := -1
  else if longint(Item1.Data) > longint(Item2.Data)
    then Compare := 1
    else Compare := StrIComp(PChar(Item1.Caption),PChar(Item2.Caption));
end; { TfrmMain.lvTZCompare }

procedure TfrmMain.dateLocalChange(Sender: TObject);

  function GetDT(dateUTC, timeuTC: TDateTimePicker): TDateTime;
  begin
    Result := Int(FixDT(dateUTC.Date))+Frac(FixDT(timeUTC.Time));
  end; { GetDT }

var
  tmp     : TDateTime;
  date2   : TDateTime;
  date    : TDateTime;
  engName : string;
  dispName: string;
  TZ      : TTimeZoneInformation;
begin
  if not changing then begin
    changing := true;
    try
      if assigned(lvTZ.Selected) and
         GetTZ(StrToIntDef(lvTZ.Selected.Subitems[2],-1),engName,dispName,TZ) then
      begin
        // Recalc UTC from Internet Time.
        if (Sender = dateSwatch) or (Sender = timeSwatch) then begin
          date := SwatchToUTC(Trunc(dateSwatch.Date),timeSwatch.Value);
          dateUTC.Date := date;
          timeUTC.Time := date;
        end;
        // Recalc Local Time from UTC.
        if (Sender = dateUTC) or (Sender = timeUTC) or
           (Sender = dateSwatch) or (Sender = timeSwatch) then
        begin
          date := UTCToTZLocalTime(TZ,GetDT(dateUTC,timeUTC));
          dateLocal.Date := date;
          timeLocal.Time := date;
          outInvalidTime.Hide; dateUTC.Show; timeUTC.Show;
        end;
        // Recalc UTC from Local Time. This will update second UTC display,
        // show Invalid Time indicator etc.
        date := TZLocalTimeToUTC(TZ,GetDT(dateLocal,timeLocal),false);
        if date <> 0 then begin // valid time
          outInvalidTime.Show;
          date2 := TZLocalTimeToUTC(TZ,GetDT(dateLocal,timeLocal),true);
          if not DateEQ(date,date2) then begin
            if DateEQ(date2,GetDT(dateUTC,timeUTC)) then begin
              tmp   := date;
              date  := date2;
              date2 := tmp;
            end;
            UTC2 := date2;
            dateUTC2.Date := date2;
            timeUTC2.Time := date2;
            dateUTC2.Show; timeUTC2.Show;
          end
          else begin
            dateUTC2.Hide; timeUTC2.Hide;
          end;
          dateUTC.Date := date;
          timeUTC.Time := date;
          dateUTC.Show; timeUTC.Show;
        end
        else begin
          dateUTC.Hide; timeUTC.Hide; dateUTC2.Hide; timeUTC2.Hide;
          outInvalidTime.Show;
        end;
        // Recalc Internet Time from all visible UTC Time controls.
        if dateUTC.Visible then begin
          timeSwatch.Value := UTCToSwatch(GetDT(dateUTC,timeUTC),date);
          dateSwatch.Date := date;
        end;
        dateSwatch.Visible := dateUTC.Visible;
        timeSwatch.Visible := dateUTC.Visible;
        lblSwatch.Visible  := dateUTC.Visible;
        lblSwatchHead.Visible := dateUTC.Visible;
        if dateUTC2.Visible then begin
          timeSwatch2.Value := UTCToSwatch(GetDT(dateUTC2,timeUTC2),Swatch2);
          dateSwatch2.Date := Swatch2;
        end;
        dateSwatch2.Visible := dateUTC2.Visible;
        timeSwatch2.Visible := dateUTC2.Visible;
        lblSwatch2.Visible  := dateUTC2.Visible;;
      end;
    finally changing := false end;
  end;
end; { TfrmMain.dateLocalChange }

procedure TfrmMain.btnLocD2SClick(Sender: TObject);
var
  StdBias : longint;
  DayBias : longint;
  StdDate : TDateTime;
  DayDate : TDateTime;
  newDT   : TDateTime;
  engName : string;
  dispName: string;
  TZ      : TTimeZoneInformation;
begin
  if assigned(lvTZ.Selected) and
     GetTZ(StrToIntDef(lvTZ.Selected.Subitems[2],-1),engName,dispName,TZ) then
  begin
    if GetTZDaylightSavingInfo (TZ, DayDate, StdDate, DayBias, StdBias) then begin
      if Sender = btnLocD2S
        then newDT := StdDate-(StdBias-DayBias)/MINUTESPERDAY
      else if Sender = btnLocS2D
        then newDT := DayDate
      else if Sender = btnLocNow
        then newDT := Now
        else newDT := 0;
      dateLocal.Date := newDT;
      timeLocal.Time := newDT;
      dateLocalChange(dateLocal);
    end;
  end;
end; { TfrmMain.btnLocD2SClick }

procedure TfrmMain.timeUTC2Change(Sender: TObject);
begin
  dateUTC2.Date := UTC2;
  timeUTC2.Time := UTC2;
  dateSwatch2.Date := Swatch2;
end; { TfrmMain.timeUTC2Change }

procedure TfrmMain.lvTZClick(Sender: TObject);
var
  DayBias     : longint;
  StdBias     : longint;
  StandardBias: longint;
  DaylightBias: longint;
  EndDate     : TDateTime;
  StartDate   : TDateTime;
  TZ          : TTimeZoneInformation;
  engName     : string;
  dispName    : string;
  Item        : TListItem;
const
  OrdNums: array [1..5] of string = ('1st', '2nd', '3rd', '4th', 'last');
begin
  if lvTZ.Selected = nil then Exit;
  Item := lvTZ.Selected;
// Most of this code was shamelessly stolen from Delphi Clinic,
// The Delphi Magazine, Issue 49. It was written by Brian Long.
   if GetTZ(StrToIntDef(Item.Subitems[2],-1),engName,dispName,TZ) then begin
     grpTimezone.Caption := ' '+dispName+' ';
     if GetTZDaylightSavingInfo (TZ, StartDate, EndDate, DaylightBias, StandardBias) then begin
       StdBias := TZ.Bias + TZ.StandardBias;
       DayBias := TZ.Bias + TZ.DaylightBias;
       outStandard.Lines.Clear;
       outDaylight.Lines.Clear;
       outStandard.Lines.Add(Format('%s, %d minute bias',[TZ.StandardName, StdBias]));
       outDaylight.Lines.Add(Format('%s, %d minute bias',[TZ.DaylightName, DayBias]));
       if TZ.StandardDate.wYear = 0 then begin //"Day of month" date
         with TZ.StandardDate do 
           outStandard.Lines.Add(Format('Starts on %s %s of %s at %s GMT', [
             OrdNums[wDay], LongDayNames[wDayOfWeek + 1], LongMonthNames[wMonth],
             TimeToStr(EncodeTime(wHour, wMinute, wSecond, wMilliseconds) + DayBias / MINUTESPERDAY)]));
         outStandard.Lines.Add('This year: '+FormatDateTime('c',EndDate));
       end
       else begin //Absolute date
         outStandard.Lines.Add('Absolute date: '+
           DateTimeToStr(SystemTimeToDateTime(TZ.StandardDate) + DayBias / MINUTESPERDAY));
       end;
       if TZ.DaylightDate.wYear = 0 then begin //"Day of month" date
         with TZ.DaylightDate do
           outDaylight.Lines.Add(Format('Starts on %s %s of %s at %s GMT', [
             OrdNums[wDay], LongDayNames[wDayOfWeek + 1], LongMonthNames[wMonth],
             TimeToStr(EncodeTime(wHour, wMinute, wSecond, wMilliseconds) + StdBias / MINUTESPERDAY)]));
           outDaylight.Lines.Add('This year: '+FormatDateTime('c',StartDate));
       end
       else begin //Absolute date
         outDaylight.Lines.Add('Absolute date: '+
           DateTimeToStr(SystemTimeToDateTime(TZ.DaylightDate) + StdBias / MINUTESPERDAY));
       end;
       btnLocD2S.Show;
       btnLocS2D.Show;
     end
     else begin // no DST
       outStandard.Text := Format('%s, %d minute bias',[TZ.StandardName, TZ.Bias]);
       outDaylight.Text := 'not used';
       btnLocD2S.Hide;
       btnLocS2D.Hide;
     end;
     outUTCBias.Text := IntToStr(GetTZBias(TZ));
     outStandard.Perform(EM_SETSEL,0,0);
     outStandard.Perform(EM_SCROLLCARET,0,0);
     outDaylight.Perform(EM_SETSEL,0,0);
     outDaylight.Perform(EM_SCROLLCARET,0,0);
     if initDate then begin
       initDate := false;
       dateLocal.Date := Trunc(Now);
       timeLocal.Time := Frac(Now);
     end;
     dateLocalChange(dateLocal);
   end;
end; { TfrmMain.lvTZClick }

end.
