;@GOTO TRANSLATE

.MODEL SMALL,PASCAL
.586P

 INCLUDE EXD.EQU

.CODE
Start:
     MOV   DX,@DATA
     MOV   CX,ES
     MOV   DS,DX

MOV	 EBP,SignDump
SUB	  BX,BX
MOV	  AL,GetVersion
INT	 003H
CMP	  BX,100H
JB	  MErr
     MOV   AX,SS

     SUB   AX,CX

     MOV   BX,SP
     SHR   BX,4
     ADD   BX,AX

     MOV   AH,4AH
     INT   21H
     JC    AllocErr

     MOV   ES,DX

ASSUME ES:_DATA

CALL	 InitScreen

MOV	 EBP,SignDump
MOV	 AL,GetDumpInfo
INT	 003H
OR	 EAX,EAX
JE	 MErr
DEC	 EAX
MOV	 TotSize  ,ECX
MOV	 StartDump,EBX
MOV	 EndDump  ,EAX ;Hlavni
MOV	 CurDump  ,EAX

;get dmp do ds bx dmpsize v ECX
MOV	 EBX,ECX
ADD	 EBX,15
SHR	 EBX,4
MOV	 AH,48H
INT	 21H
JC	 AllocErr
MOV	 _DmpSeg,AX
MOV	 GS,AX


NewDump:
MOV	  AL,GetDump
MOV	 ECX,TotSize
SUB	 EDX,EDX
MOV	 EBX,CurDump
MOV	  SI,DX
MOV	  GS,_DmpSeg
INT	 003H
JC	 MErr

CALL	 ViewRegs PASCAL,GS SI

MOV	 ECX,TotSize
MOV	 EDX,RegsSize
MOV	 EBX,InfoSize
SUB	 ECX,EDX
ADD	  SI,DX
SUB	 ECX,EBX
ADD	  SI,BX
MOV	 DmpSize, ECX
MOV	 DmpStartOff, SI
MOV	 DmpStartSeg, GS
MOV	 DmpOff     , 00

NViewDump:
CALL	 PrintDump PASCAL, DmpStartSeg DmpStartOff

NextKey:
  MOV	 AH,10H
  INT	 16H
  MOV	 AL,AH
  LEA	 DI,KeyTab
  MOV	 CX,KeyTabL
  MOV	 SI,DI
  CLD
  REPNE  SCASB
  JNE	 NextKey
  SUB	 DI,SI
  ADD	 DI,DI
  JMP	 KeyFunc[DI]-2

  Help:
  JMP	 NextKey

 SaveNOW:
  PUSH	 DS
  MOV	 AH,3CH
  SUB	 CX,CX
  LEA	 DX,SavedNOW
  INT	 21H
  JC	 DOSFileErr
  MOV	 BX,AX
  MOV	 SI,GS
  MOV	 EDX,RegsSize
  MOV	 ECX,0FFF0H
  ADD	 EDX,InfoSize
  MOV	 EDI,DMPSize
  JMP	 BeginWrite
 NextPartOfFile:
  ADD	 SI,0FFFH
 BeginWrite:
  SUB	 EDI,ECX
  JNL	 SaveFull
  ADD	 EDI,ECX
  MOV	 ECX,EDI
  SUB	 EDI,EDI
 SaveFull:
  MOV	 DS,SI
  MOV	 AH,40H
  INT	 21H
  JC	 DOSFileErr
  OR	 EDI,EDI
;     CMP   AX,CX
;     JE    NextPartOfFile
  JNE	 NextPartOfFile
  MOV	 AH,3EH
  INT	 21H
  ;JC	  DOSFileErr


 DOSFileErr:
  POP	 DS
  JC	 BadSaved
  MOV	 AX,0E07H
  INT	 10H
 BadSaved:
  INC	 IncNum
  JMP	 NextKey


  SaveBIG:
  MOV	  AH,2
  JMP	  SaveF

  SaveCOM:
  MOV	  AH,1
  JMP	  SaveF

  SaveEXEa:
   MOV	  AH,0
  SaveF:
   MOV	  AL,SaveEXE
   MOV	  EBX,CurDump
   INT	  003H
   MOV	  AL,MakeEXE
   CMP	  AH,1
   JNE	  Returnus
   MOV	  AL,MakeCOM
  Returnus:
   JMP	  Return

  ChangeMode:
   XOR	  ViewMode,1
   JMP	  NViewDump

  Filter:
   CMP	  ViewMode,HEXMode
   JE	  NextKey
   XOR	  Filta,1
   JMP	  NViewDump

  ScrUP:
   CALL   GetScrSize
   SUB	  EBX,EBX
   CMP	  EBX,DmpOff
  NextKey1:
   JE	  NextKey
   SUB	  DmpOff,EAX
   JNS	  GoodSize0
   MOV	  DmpOff     , EBX
  GoodSize0:
   JMP	  NViewDump

  ScrDN:
   CALL   GetScrSize
   ADD	  DmpOff,EAX
   MOV	  ECX,DmpSize
   SUB	  ECX,EAX
   CMP	  ECX,DmpOff
   JG	  GoodSize0
   JE	  NextKey1
   MOV	  DmpOff     , ECX
   JMP	  GoodSize0

  Home:
   SUB	  ECX,ECX
  Here00:
   MOV	  DmpOff   ,ECX
   JMP	  NViewDump

  Enda:
   MOV	  ECX,DmpSize
   CALL   GetScrSize
   SUB	  ECX,EAX
   JMP	  Here00

  UpArrow:
   MOV	  ECX,DmpOff
   CALL   GetScrSize
   JECXZ  NKey
   SUB	  ECX,EDX
   JMP	  Here00

  DownArrow:
   MOV	  ECX,DmpOff
   MOV	  EBX,DmpSize
   CALL   GetScrSize
   SUB	  EBX,EAX
   ADD	  ECX,EDX
   CMP	  ECX,EBX
   JB	  Here00
   JE	  NKey
   JMP	  ScrDn
  NKey:
   JMP	  NextKey


  GetScrSize:
   MOV	  EAX,DmpLines*DlineL
   MOV	  EDX,DlineL
   CMP	  ViewMode,TextMode
   JE	  GoodCalc
   MOV	  EAX,DmpLines*26    ;26 BYTE V HEX
   MOV	  EDX,26    ;26 BYTE V HEX
  GoodCalc:
   RET



  PrevDmp:
   MOV	  EAX,CurDump
   CMP	  EAX,StartDump
   JE	  NextKey
   DEC	  EAX
   MOV	  CurDump,EAX
   JMP	  NewDump

  NextDmp:
   MOV	  EAX,CurDump
   CMP	  EAX,EndDump
   JE	  NextKey
   INC	  EAX
   MOV	  CurDump,EAX
   JMP	  NewDump

  QuitView:
   MOV	AL,0
  Return:
   MOV	AH,4CH
   PUSH AX
   MOV	AH,49H
   MOV	ES,_DmpSeg
   INT	21H
;   MOV  AH,0
;   MOV  AL,OrigVMode
   MOV	 AX,500H
   INT	 10H
   POP	AX
   INT	21H

  AllocErr:
   LEA	DX,AllErr
   MOV	AH,9
   INT	21H
  MErr:
   .EXIT -1



InitScreen PROC PASCAL
;   MOV   AH,0FH
;   INT   10H
;   MOV   OrigVMode,AL
;   MOV   AX,3
;   INT   10H
   MOV	 AX,5*256+GPage
   INT	 10H
   CALL  PrintStr PASCAL, DS OFFSET ViewScreen, 0,0,ScreenSize,20H,GPage
   RET
   ENDP


DDToStr PROC PASCAL
     ARG  @@Value0:dword,@@StrPtr,Figures
     USES DI,CX

     std
     mov di,@@StrPtr
     mov cx,Figures
     mov edx,@@Value0
     add di,cx
     dec di

  @@Cykl:
     mov al,dl
     and al,0Fh
     add al,'0'
     cmp al,'9'
     jBE @@Alpha
     add al,7
    @@Alpha:
     stosb
     shr edx,4
     LOOP @@Cykl
  @@Konec:
       RET

DDToStr   ENDP
  PrintStr  PROC PASCAL SPTR:DWORD,Lin:BYTE,Colu:BYTE,Leng,Attr:BYTE,Pg:BYTE
    USES  DS
    CLD
    LDS   SI,SPTR
    MOV   BH,Pg
    MOV   DH,Lin
    MOV   DL,Colu
    MOV   BL,Attr
    MOV   CX,1
   WrLoop:
    CMP   DL,80
    JB	  NoUpdateLine
    INC   DH
    MOV   DL,Colu
  NoUpdateLine:
    MOV   AH,2
    INT   10H
    LODSB
    INC   DL
    MOV   AH,9
    INT   10H
    DEC   Leng
    JNLE  WrLoop
    RET
    ENDP

 PrintTextDump	PROC PASCAL SPTR:DWORD
    USES  DS
    CLD
    LDS   SI,SPTR
    MOV   BH,GPage
    MOV   DH,FirstDumpLine
    MOV   DL,FirstDumpCol
    MOV   BL,DumpAttrib
    MOV   CX,1
   WrTextLoop:
    CMP   DL,LastDumpCol
    JBE   NoUpdateL
    CMP   DH,LastDumpLine
    JAE   QuitText
    INC   DH
    MOV   DL,FirstDumpCol
   NoUpdateL:
    MOV   AH,2
    INT   10H
    LODSB
    CMP   ES:Filta,ASCII
    JNE   NextFlt
    CMP   AL,' '
    JB	  DoSpace
    CMP   AL,7EH
    JNA   NextFlt
   DoSpace:
    MOV   AL,' '
   NextFlt:
    INC   DL
    MOV   AH,9
    INT   10H
    JMP   WrTextLoop
   QuitText:
    MOV   AX,SI
    SUB   AX,WORD PTR SPTR ;CX POCET ZAPSANYCH ZNAKU
    RET
    ENDP

PrintReg PROC PASCAL REGI:DWORD, REGPROP ,RSIZE
   USES  BX,SI
   CALL  DDToStr PASCAL,REGI, OFFSET RegStr,RSIZE
   MOV	 SI,REGPROP
   CALL  PrintStr PASCAL, ES OFFSET RegStr, [SI].RLINE,[SI].RCOL,RSIZE,[SI].RATR,GPage
   RET
   ENDP

ViewRegs PROC PASCAL REGSIMAGE:DWORD
   USES  BX
   LFS	 SI,REGSIMAGE
   SUB	 BX,BX
   LEA	 DI,REGPOSTEXT
 PrintNextReg:
   CALL  PrintReg PASCAL, DWORD PTR FS:[BX+SI],DI,4
   ADD	 BX,4
   ADD	 DI, SIZE REGREC
   CMP	 BX,4*18+8-8
   JE	 RegsPrinted	;DUMP#,PSP
   CMP	 BX,4*3+8 ;ESP	;EDI,ESI,EBP,ESP,EBX,EDX,ECX,EAX,
			;ERR,EIP,ECS,EFL,ESP,ESS,EES,EDS,epos;EFS,EGS
   JE	 SkipDD
   CMP	 BX,4*8+8 ;ERR
   JNE	 PrintNextReg
  SkipDD:
   ;SUB   DI, SIZE REGREC
   ADD	 BX,4
   JMP	 PrintNextReg
  RegsPrinted:
   RET
ViewRegs ENDP


PrintDump PROC PASCAL DMPSTSG,DMPSTOF
   USES  DS

   CALL  PrintReg PASCAL, DmpOff, OFFSET T_POS, 8

   MOVZX EBX,DMPSTSG
   SHL	 EBX,4
   MOVZX EAX,DMPSTOF
   ADD	 EBX,EAX
   ADD	 EBX,DmpOff
   MOV	 EAX,EBX
   SHR	 EAX,4
   AND	 BX,1111B



   ;ZOBRAZ IMAGE
   CMP	 ViewMode,HEXMode
   JE	 HexView
   CMP	 ViewMode,TextMode
   JE	 TextView
 HexView:
   CALL  PrintHexDump PASCAL, AX BX
   JMP	 UpdDumpa
 TextView:
   CALL  PrintTextDump PASCAL, AX BX
  UpdDumpa:
   MOV	 AH,2
   MOV	 BH,GPage
   MOV	 DX,25*256
   INT	 10H
   RET
   ENDP


 PrintHexDump PROC PASCAL SPTR:DWORD
    USES  DS
    CLD
    LDS   SI,SPTR
    MOV   BH,GPage
    MOV   DH,FirstDumpLine
    MOV   DL,FirstDumpCol
    MOV   BL,DumpAttrib
    MOV   CX,1
   WriLoop:
    CMP   DL,LastDumpCol
    JB	  NoUpdLine
    CMP   DH,LastDumpLine
    JAE   QuitHex
    INC   DH
    MOV   DL,FirstDumpCol
   NoUpdLine:
    LODSB
    AAM   16
    CMP   AL,9
    JBE   OkAL
    ADD   AL,7
   OkAL:
    ADD   AL,'0'
    XCHG  AH,AL
    CMP   AL,9
    JBE   OkAL1
    ADD   AL,7
   OkAL1:
    ADD   AL,'0'
    CALL  WriteSegment
    JMP   WriLoop
  QuitHex:
    MOV   AX,SI
    SUB   AX,WORD PTR SPTR ;CX POCET ZAPSANYCH ZNAKU
    RET
    ENDP

WriteSegment PROC PASCAL
    PUSH  AX
    MOV   AH,2
    INT   10H
    MOV   AH,9
    INT   10H
    INC   DL
    MOV   AH,2
    INT   10H
    POP   AX
    MOV   AL,AH
    MOV   AH,9
    INT   10H
    INC   DL
    MOV   AH,2
    INT   10H
    MOV   AX,0920H
    INT   10H
    INC   DL
    RET
    ENDP


.DATA
   DB 'z0nE'
   SignDump DD _SignDump
   RegsSize DD _RegsSize
   InfoSize DD _InfoSize

	    ;ESC, F1, F2,  F3,	F4,   F5, F6, f7,PGUP, PGDN, left ,right
  KeyTab  DB 01H, 3BH,3CH, 3DH, 3EH, 3FH, 40H,41h, 49H, 51H,  4BH,  4DH
	    ;Home,  End,  Up,	Dn
	  DB 47H , 4Fh,  48h,  50h
  KeyTabL EQU $-KeyTab
  KeyFunc DW QuitView, Help, SaveNOW, SaveCOM, SaveEXEa, SaveBIG, Filter, ChangeMode,ScrUP, ScrDN
	  DW PrevDmp, NextDmp, Home, Enda, UpArrow, DownArrow

   AllErr DB 13,10,"DOS memory service failed!",7,36
   SavedNOW DB "EDUMPED"
     IncNum DB "0.NOW",0

  TextMode   EQU 0
  HEXMode    EQU 1
  ViewMode   DB  TextMode

  AllChars   EQU 0
  ASCII      EQU 1
  Filta      DB  ASCII ;AllChars

  DumpAttrib EQU 20H
  GPage      EQU 01H
  AtrMode    EQU 00H
  FirstDumpLine EQU  4
  FirstDumpCol	EQU  1
  DLineL	EQU  78
  LastDumpLine	EQU  20
  LastDumpCol	EQU  78
  DmpLines   EQU LastDumpLine - FirstDumpLine +1

ViewScreen LABEL
INCLUDE  edView.SCR
ScreenSize EQU $-ViewScreen

   REGREC  STRUC
    RLINE  LABEL WORD
	   DB ?
    RCOL   LABEL WORD
	   DB ?
    RATR   LABEL WORD
	   DB ?
   REGREC  ENDS

 REGPOSTEXT LABEL
   T_PSP   REGREC  <2,59,20H>
   T_DMP   REGREC  <1,08,20H>
   T_EDI   REGREC  <1,66,20H>
   T_ESI   REGREC  <1,58,20H>
   T_EBP   REGREC  <1,50,20H>
   T_EBX   REGREC  <1,26,20H>
   T_EDX   REGREC  <1,42,20H>
   T_ECX   REGREC  <1,34,20H>
   T_EAX   REGREC  <1,18,20H>
   T_EIP   REGREC  <2,30,20H>
   T_ECS   REGREC  <2,25,20H>
   T_EFL   REGREC  <1,74,20H>
   T_ESP   REGREC  <2,13,20H>
   T_ESS   REGREC  <2,08,20H>
   T_EES   REGREC  <2,48,20H>
   T_EDS   REGREC  <2,39,20H>
   T_POS   REGREC  <2,70,20H>
;   T_EFS   REGREC  <2,55,20H>
;   T_EGS   REGREC  <2,63,20H>

  TotSize   DD ?
  StartDump DD ?
  EndDump   DD ?
  CurDump   DD ?

  _DmpSeg   DW ?


  ;OrigVMode DB ?
  DmpSize DD ?
  DmpOff  DD ?
  DmpStartOff DW ?
  DmpStartSeg DW ?
  NowLine DW ?
  NowCol  DW ?
  RegStr  DD ?
	  DD ?
.STACK 256

 END  Start

:TRANSLATE
   @echo off
   tasm  /m /q /z edVIEW.BAT
   rem TLink /3/x edVIEW.OBJ
   link386	  edVIEW.OBJ
   del		  edVIEW.OBJ
