; Kinds
kArOp		equ	2
kGrp1		equ	3
kGrp2		equ	4
kGrp3		equ	5
kShfOp		equ	6

; Mnemonics
s_mAAA		db	'aaa', 0
s_mAAD		db	'aad', 0
s_mAAM		db	'aam', 0
s_mAAS		db	'aas', 0
s_mADC		db	'adc', 0
s_mADD		db	'add', 0
s_mAND		db	'and', 0
s_mCALL		db	'call', 0
s_mCBW		db	'cbw', 0
s_mCLC		db	'clc', 0
s_mCLD		db	'cld', 0
s_mCLI		db	'cli', 0
s_mCMC		db	'cmc', 0
s_mCMP		db	'cmp', 0
s_mCMPSB	db	'cmpsb', 0
s_mCMPSW	db	'cmpsw', 0
s_mCWD		db	'cwd', 0
s_mDAA		db	'daa', 0
s_mDAS		db	'das', 0
s_mDEC		db	'dec', 0
s_mDIV		db	'div', 0
s_mHLT		db	'hlt', 0
s_mIDIV		db	'idiv', 0
s_mIMUL		db	'imul', 0
s_mIN		db	'in', 0
s_mINC		db	'inc', 0
s_mINT		db	'int', 0
s_mINTO		db	'into', 0
s_mIRET		db	'iret', 0
s_mJA		db	'ja', 0
s_mJAE		db	'jae', 0
s_mJB		db	'jb', 0
s_mJBE		db	'jbe', 0
s_mJCXZ		db	'jcxz', 0
s_mJG		db	'jg', 0
s_mJGE		db	'jge', 0
s_mJL		db	'jl', 0
s_mJLE		db	'jle', 0
s_mJMP		db	'jmp', 0
s_mJNO		db	'jno', 0
s_mJNS		db	'jns', 0
s_mJNZ		db	'jnz', 0
s_mJO		db	'jo', 0
s_mJPE		db	'jpe', 0
s_mJPO		db	'jpo', 0
s_mJS		db	'js', 0
s_mJZ		db	'jz', 0
s_mLAHF		db	'lahf', 0
s_mLDS		db	'lds', 0
s_mLEA		db	'lea', 0
s_mLES		db	'les', 0
s_mLOCK		db	'lock', 0
s_mLODSB	db	'lodsb', 0
s_mLODSW	db	'lodsw', 0
s_mLOOP		db	'loop', 0
s_mLOOPNZ	db	'loopnz', 0
s_mLOOPZ	db	'loopz', 0
s_mMOV		db	'mov', 0
s_mMOVSB	db	'movsb', 0
s_mMOVSW	db	'movsw', 0
s_mMUL		db	'mul', 0
s_mNEG		db	'neg', 0
s_mNOP		db	'nop', 0
s_mNOT		db	'not', 0
s_mOR		db	'or', 0
s_mOUT		db	'out', 0
s_mPOP		db	'pop', 0
s_mPOPF		db	'popf', 0
s_mPUSH		db	'push', 0
s_mPUSHF	db	'pushf', 0
s_mRCL		db	'rcl', 0
s_mRCR		db	'rcr', 0
s_mREP		db	'rep', 0
s_mREPNE	db	'repne', 0
s_mRETF		db	'retf', 0
s_mRETN		db	'retn', 0
s_mROL		db	'rol', 0
s_mROR		db	'ror', 0
s_mSAHF		db	'sahf', 0
s_mSAR		db	'sar', 0
s_mSBB		db	'sbb', 0
s_mSCASB	db	'scasb', 0
s_mSCASW	db	'scasw', 0
s_mSEGCS	db	'segcs', 0
s_mSEGDS	db	'segds', 0
s_mSEGES	db	'seges', 0
s_mSEGSS	db	'segss', 0
s_mSHL		db	'shl', 0
s_mSHR		db	'shr', 0
s_mSTC		db	'stc', 0
s_mSTD		db	'std', 0
s_mSTI		db	'sti', 0
s_mSTOSB	db	'stosb', 0
s_mSTOSW	db	'stosw', 0
s_mSUB		db	'sub', 0
s_mTEST		db	'test', 0
s_mWAIT		db	'wait', 0
s_mXCHG		db	'xchg', 0
s_mXLAT		db	'xlat', 0
s_mXOR		db	'xor', 0

; Opcodes
label	Opcodes	TOpcodeData
	TOpcodeData	<s_mADD, kNormal, argRegMem8, argReg8>		; 0x00
	TOpcodeData	<s_mADD, kNormal, argRegMem16, argReg16>	; 0x01
	TOpcodeData	<s_mADD, kNormal, argReg8, argRegMem8>		; 0x02
	TOpcodeData	<s_mADD, kNormal, argReg16, argRegMem16>	; 0x03
	TOpcodeData	<s_mADD, kNormal, argRegAL, argImm8>		; 0x04
	TOpcodeData	<s_mADD, kNormal, argRegAX, argImm16>		; 0x05
	TOpcodeData	<s_mPUSH, kNormal, argRegES, argNone>		; 0x06
	TOpcodeData	<s_mPOP, kNormal, argRegES, argNone>		; 0x07
	TOpcodeData	<s_mOR, kNormal, argRegMem8, argReg8>		; 0x08
	TOpcodeData	<s_mOR, kNormal, argRegMem16, argReg16>		; 0x09
	TOpcodeData	<s_mOR, kNormal, argReg8, argRegMem8>		; 0x0A
	TOpcodeData	<s_mOR, kNormal, argReg16, argRegMem16>		; 0x0B
	TOpcodeData	<s_mOR, kNormal, argRegAL, argImm8>		; 0x0C
	TOpcodeData	<s_mOR, kNormal, argRegAX, argImm16>		; 0x0D
	TOpcodeData	<s_mPUSH, kNormal, argRegCS, argNone>		; 0x0E
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x0F
	TOpcodeData	<s_mADC, kNormal, argRegMem8, argReg8>		; 0x10
	TOpcodeData	<s_mADC, kNormal, argRegMem16, argReg16>	; 0x11
	TOpcodeData	<s_mADC, kNormal, argReg8, argRegMem8>		; 0x12
	TOpcodeData	<s_mADC, kNormal, argReg16, argRegMem16>	; 0x13
	TOpcodeData	<s_mADC, kNormal, argRegAL, argImm8>		; 0x14
	TOpcodeData	<s_mADC, kNormal, argRegAX, argImm16>		; 0x15
	TOpcodeData	<s_mPUSH, kNormal, argRegSS, argNone>		; 0x16
	TOpcodeData	<s_mPOP, kNormal, argRegSS, argNone>		; 0x17
	TOpcodeData	<s_mSBB, kNormal, argRegMem8, argReg8>		; 0x18
	TOpcodeData	<s_mSBB, kNormal, argRegMem16, argReg16>	; 0x19
	TOpcodeData	<s_mSBB, kNormal, argReg8, argRegMem8>		; 0x1A
	TOpcodeData	<s_mSBB, kNormal, argReg16, argRegMem16>	; 0x1B
	TOpcodeData	<s_mSBB, kNormal, argRegAL, argImm8>		; 0x1C
	TOpcodeData	<s_mSBB, kNormal, argRegAX, argImm16>		; 0x1D
	TOpcodeData	<s_mPUSH, kNormal, argRegDS, argNone>		; 0x1E
	TOpcodeData	<s_mPOP, kNormal, argRegDS, argNone>		; 0x1F
	TOpcodeData	<s_mAND, kNormal, argRegMem8, argReg8>		; 0x20
	TOpcodeData	<s_mAND, kNormal, argRegMem16, argReg16>	; 0x21
	TOpcodeData	<s_mAND, kNormal, argReg8, argRegMem8>		; 0x22
	TOpcodeData	<s_mAND, kNormal, argReg16, argRegMem16>	; 0x23
	TOpcodeData	<s_mAND, kNormal, argRegAL, argImm8>		; 0x24
	TOpcodeData	<s_mAND, kNormal, argRegAX, argImm16>		; 0x25
	TOpcodeData	<s_mSEGES, kPrefix, argNone, argNone>		; 0x26
	TOpcodeData	<s_mDAA, kNormal, argNone, argNone>		; 0x27
	TOpcodeData	<s_mSUB, kNormal, argRegMem8, argReg8>		; 0x28
	TOpcodeData	<s_mSUB, kNormal, argRegMem16, argReg16>	; 0x29
	TOpcodeData	<s_mSUB, kNormal, argReg8, argRegMem8>		; 0x2A
	TOpcodeData	<s_mSUB, kNormal, argReg16, argRegMem16>	; 0x2B
	TOpcodeData	<s_mSUB, kNormal, argRegAL, argImm8>		; 0x2C
	TOpcodeData	<s_mSUB, kNormal, argRegAX, argImm16>		; 0x2D
	TOpcodeData	<s_mSEGCS, kPrefix, argNone, argNone>		; 0x2E
	TOpcodeData	<s_mDAS, kNormal, argNone, argNone>		; 0x2F
	TOpcodeData	<s_mXOR, kNormal, argRegMem8, argReg8>		; 0x30
	TOpcodeData	<s_mXOR, kNormal, argRegMem16, argReg16>	; 0x31
	TOpcodeData	<s_mXOR, kNormal, argReg8, argRegMem8>		; 0x32
	TOpcodeData	<s_mXOR, kNormal, argReg16, argRegMem16>	; 0x33
	TOpcodeData	<s_mXOR, kNormal, argRegAL, argImm8>		; 0x34
	TOpcodeData	<s_mXOR, kNormal, argRegAX, argImm16>		; 0x35
	TOpcodeData	<s_mSEGSS, kPrefix, argNone, argNone>		; 0x36
	TOpcodeData	<s_mAAA, kNormal, argNone, argNone>		; 0x37
	TOpcodeData	<s_mCMP, kNormal, argRegMem8, argReg8>		; 0x38
	TOpcodeData	<s_mCMP, kNormal, argRegMem16, argReg16>	; 0x39
	TOpcodeData	<s_mCMP, kNormal, argReg8, argRegMem8>		; 0x3A
	TOpcodeData	<s_mCMP, kNormal, argReg16, argRegMem16>	; 0x3B
	TOpcodeData	<s_mCMP, kNormal, argRegAL, argImm8>		; 0x3C
	TOpcodeData	<s_mCMP, kNormal, argRegAX, argImm16>		; 0x3D
	TOpcodeData	<s_mSEGDS, kPrefix, argNone, argNone>		; 0x3E
	TOpcodeData	<s_mAAS, kNormal, argNone, argNone>		; 0x3F
	TOpcodeData	<s_mINC, kNormal, argRegAX, argNone>		; 0x40
	TOpcodeData	<s_mINC, kNormal, argRegCX, argNone>		; 0x41
	TOpcodeData	<s_mINC, kNormal, argRegDX, argNone>		; 0x42
	TOpcodeData	<s_mINC, kNormal, argRegBX, argNone>		; 0x43
	TOpcodeData	<s_mINC, kNormal, argRegSP, argNone>		; 0x44
	TOpcodeData	<s_mINC, kNormal, argRegBP, argNone>		; 0x45
	TOpcodeData	<s_mINC, kNormal, argRegSI, argNone>		; 0x46
	TOpcodeData	<s_mINC, kNormal, argRegDI, argNone>		; 0x47
	TOpcodeData	<s_mDEC, kNormal, argRegAX, argNone>		; 0x48
	TOpcodeData	<s_mDEC, kNormal, argRegCX, argNone>		; 0x49
	TOpcodeData	<s_mDEC, kNormal, argRegDX, argNone>		; 0x4A
	TOpcodeData	<s_mDEC, kNormal, argRegBX, argNone>		; 0x4B
	TOpcodeData	<s_mDEC, kNormal, argRegSP, argNone>		; 0x4C
	TOpcodeData	<s_mDEC, kNormal, argRegBP, argNone>		; 0x4D
	TOpcodeData	<s_mDEC, kNormal, argRegSI, argNone>		; 0x4E
	TOpcodeData	<s_mDEC, kNormal, argRegDI, argNone>		; 0x4F
	TOpcodeData	<s_mPUSH, kNormal, argRegAX, argNone>		; 0x50
	TOpcodeData	<s_mPUSH, kNormal, argRegCX, argNone>		; 0x51
	TOpcodeData	<s_mPUSH, kNormal, argRegDX, argNone>		; 0x52
	TOpcodeData	<s_mPUSH, kNormal, argRegBX, argNone>		; 0x53
	TOpcodeData	<s_mPUSH, kNormal, argRegSP, argNone>		; 0x54
	TOpcodeData	<s_mPUSH, kNormal, argRegBP, argNone>		; 0x55
	TOpcodeData	<s_mPUSH, kNormal, argRegSI, argNone>		; 0x56
	TOpcodeData	<s_mPUSH, kNormal, argRegDI, argNone>		; 0x57
	TOpcodeData	<s_mPOP, kNormal, argRegAX, argNone>		; 0x58
	TOpcodeData	<s_mPOP, kNormal, argRegCX, argNone>		; 0x59
	TOpcodeData	<s_mPOP, kNormal, argRegDX, argNone>		; 0x5A
	TOpcodeData	<s_mPOP, kNormal, argRegBX, argNone>		; 0x5B
	TOpcodeData	<s_mPOP, kNormal, argRegSP, argNone>		; 0x5C
	TOpcodeData	<s_mPOP, kNormal, argRegBP, argNone>		; 0x5D
	TOpcodeData	<s_mPOP, kNormal, argRegSI, argNone>		; 0x5E
	TOpcodeData	<s_mPOP, kNormal, argRegDI, argNone>		; 0x5F
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x60
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x61
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x62
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x63
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x64
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x65
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x66
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x67
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x68
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x69
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x6A
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x6B
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x6C
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x6D
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x6E
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x6F
	TOpcodeData	<s_mJO, kNormal, argShort, argNone>		; 0x70
	TOpcodeData	<s_mJNO, kNormal, argShort, argNone>		; 0x71
	TOpcodeData	<s_mJB, kNormal, argShort, argNone>		; 0x72
	TOpcodeData	<s_mJAE, kNormal, argShort, argNone>		; 0x73
	TOpcodeData	<s_mJZ, kNormal, argShort, argNone>		; 0x74
	TOpcodeData	<s_mJNZ, kNormal, argShort, argNone>		; 0x75
	TOpcodeData	<s_mJBE, kNormal, argShort, argNone>		; 0x76
	TOpcodeData	<s_mJA, kNormal, argShort, argNone>		; 0x77
	TOpcodeData	<s_mJS, kNormal, argShort, argNone>		; 0x78
	TOpcodeData	<s_mJNS, kNormal, argShort, argNone>		; 0x79
	TOpcodeData	<s_mJPE, kNormal, argShort, argNone>		; 0x7A
	TOpcodeData	<s_mJPO, kNormal, argShort, argNone>		; 0x7B
	TOpcodeData	<s_mJL, kNormal, argShort, argNone>		; 0x7C
	TOpcodeData	<s_mJGE, kNormal, argShort, argNone>		; 0x7D
	TOpcodeData	<s_mJLE, kNormal, argShort, argNone>		; 0x7E
	TOpcodeData	<s_mJG, kNormal, argShort, argNone>		; 0x7F
	TOpcodeData	<0, kArOp, argRegMem8, argImm8>			; 0x80
	TOpcodeData	<0, kArOp, argRegMem16, argImm16>		; 0x81
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0x82
	TOpcodeData	<0, kArOp, argRegMem16, argSImm8>		; 0x83
	TOpcodeData	<s_mTEST, kNormal, argRegMem8, argReg8>		; 0x84
	TOpcodeData	<s_mTEST, kNormal, argRegMem16, argReg16>	; 0x85
	TOpcodeData	<s_mXCHG, kNormal, argReg8, argRegMem8>		; 0x86
	TOpcodeData	<s_mXCHG, kNormal, argReg16, argRegMem16>	; 0x87
	TOpcodeData	<s_mMOV, kNormal, argRegMem8, argReg8>		; 0x88
	TOpcodeData	<s_mMOV, kNormal, argRegMem16, argReg16>	; 0x89
	TOpcodeData	<s_mMOV, kNormal, argReg8, argRegMem8>		; 0x8A
	TOpcodeData	<s_mMOV, kNormal, argReg16, argRegMem16>	; 0x8B
	TOpcodeData	<s_mMOV, kNormal, argRegMem16, argSegReg>	; 0x8C
	TOpcodeData	<s_mLEA, kNormal, argReg16, argMem8>		; 0x8D
	TOpcodeData	<s_mMOV, kNormal, argSegReg, argRegMem16>	; 0x8E
	TOpcodeData	<s_mPOP, kNormal, argRegMem16, argNone>		; 0x8F
	TOpcodeData	<s_mNOP, kNormal, argNone, argNone>		; 0x90
	TOpcodeData	<s_mXCHG, kNormal, argRegAX, argRegCX>		; 0x91
	TOpcodeData	<s_mXCHG, kNormal, argRegAX, argRegDX>		; 0x92
	TOpcodeData	<s_mXCHG, kNormal, argRegAX, argRegBX>		; 0x93
	TOpcodeData	<s_mXCHG, kNormal, argRegAX, argRegSP>		; 0x94
	TOpcodeData	<s_mXCHG, kNormal, argRegAX, argRegBP>		; 0x95
	TOpcodeData	<s_mXCHG, kNormal, argRegAX, argRegSI>		; 0x96
	TOpcodeData	<s_mXCHG, kNormal, argRegAX, argRegDI>		; 0x97
	TOpcodeData	<s_mCBW, kNormal, argNone, argNone>		; 0x98
	TOpcodeData	<s_mCWD, kNormal, argNone, argNone>		; 0x99
	TOpcodeData	<s_mCALL, kNormal, argFar, argNone>		; 0x9A
	TOpcodeData	<s_mWAIT, kNormal, argNone, argNone>		; 0x9B
	TOpcodeData	<s_mPUSHF, kNormal, argNone, argNone>		; 0x9C
	TOpcodeData	<s_mPOPF, kNormal, argNone, argNone>		; 0x9D
	TOpcodeData	<s_mSAHF, kNormal, argNone, argNone>		; 0x9E
	TOpcodeData	<s_mLAHF, kNormal, argNone, argNone>		; 0x9F
	TOpcodeData	<s_mMOV, kNormal, argRegAL, argMemOffs8>	; 0xA0
	TOpcodeData	<s_mMOV, kNormal, argRegAX, argMemOffs16>	; 0xA1
	TOpcodeData	<s_mMOV, kNormal, argMemOffs8, argRegAL>	; 0xA2
	TOpcodeData	<s_mMOV, kNormal, argMemOffs16, argRegAX>	; 0xA3
	TOpcodeData	<s_mMOVSB, kNormal, argNone, argNone>		; 0xA4
	TOpcodeData	<s_mMOVSW, kNormal, argNone, argNone>		; 0xA5
	TOpcodeData	<s_mCMPSB, kNormal, argNone, argNone>		; 0xA6
	TOpcodeData	<s_mCMPSW, kNormal, argNone, argNone>		; 0xA7
	TOpcodeData	<s_mTEST, kNormal, argRegAL, argImm8>		; 0xA8
	TOpcodeData	<s_mTEST, kNormal, argRegAX, argImm16>		; 0xA9
	TOpcodeData	<s_mSTOSB, kNormal, argNone, argNone>		; 0xAA
	TOpcodeData	<s_mSTOSW, kNormal, argNone, argNone>		; 0xAB
	TOpcodeData	<s_mLODSB, kNormal, argNone, argNone>		; 0xAC
	TOpcodeData	<s_mLODSW, kNormal, argNone, argNone>		; 0xAD
	TOpcodeData	<s_mSCASB, kNormal, argNone, argNone>		; 0xAE
	TOpcodeData	<s_mSCASW, kNormal, argNone, argNone>		; 0xAF
	TOpcodeData	<s_mMOV, kNormal, argRegAL, argImm8>		; 0xB0
	TOpcodeData	<s_mMOV, kNormal, argRegCL, argImm8>		; 0xB1
	TOpcodeData	<s_mMOV, kNormal, argRegDL, argImm8>		; 0xB2
	TOpcodeData	<s_mMOV, kNormal, argRegBL, argImm8>		; 0xB3
	TOpcodeData	<s_mMOV, kNormal, argRegAH, argImm8>		; 0xB4
	TOpcodeData	<s_mMOV, kNormal, argRegCH, argImm8>		; 0xB5
	TOpcodeData	<s_mMOV, kNormal, argRegDH, argImm8>		; 0xB6
	TOpcodeData	<s_mMOV, kNormal, argRegBH, argImm8>		; 0xB7
	TOpcodeData	<s_mMOV, kNormal, argRegAX, argImm16>		; 0xB8
	TOpcodeData	<s_mMOV, kNormal, argRegCX, argImm16>		; 0xB9
	TOpcodeData	<s_mMOV, kNormal, argRegDX, argImm16>		; 0xBA
	TOpcodeData	<s_mMOV, kNormal, argRegBX, argImm16>		; 0xBB
	TOpcodeData	<s_mMOV, kNormal, argRegSP, argImm16>		; 0xBC
	TOpcodeData	<s_mMOV, kNormal, argRegBP, argImm16>		; 0xBD
	TOpcodeData	<s_mMOV, kNormal, argRegSI, argImm16>		; 0xBE
	TOpcodeData	<s_mMOV, kNormal, argRegDI, argImm16>		; 0xBF
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xC0
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xC1
	TOpcodeData	<s_mRETN, kNormal, argImm16, argNone>		; 0xC2
	TOpcodeData	<s_mRETN, kNormal, argNone, argNone>		; 0xC3
	TOpcodeData	<s_mLES, kNormal, argReg16, argMem32>		; 0xC4
	TOpcodeData	<s_mLDS, kNormal, argReg16, argMem32>		; 0xC5
	TOpcodeData	<s_mMOV, kNormal, argMem8, argImm8>		; 0xC6
	TOpcodeData	<s_mMOV, kNormal, argMem16, argImm16>		; 0xC7
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xC8
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xC9
	TOpcodeData	<s_mRETF, kNormal, argImm16, argNone>		; 0xCA
	TOpcodeData	<s_mRETF, kNormal, argNone, argNone>		; 0xCB
	TOpcodeData	<s_mINT, kNormal, argConst3, argNone>		; 0xCC
	TOpcodeData	<s_mINT, kNormal, argImm8, argNone>		; 0xCD
	TOpcodeData	<s_mINTO, kNormal, argNone, argNone>		; 0xCE
	TOpcodeData	<s_mIRET, kNormal, argNone, argNone>		; 0xCF
	TOpcodeData	<0, kShfOp, argRegMem8, argConst1>		; 0xD0
	TOpcodeData	<0, kShfOp, argRegMem16, argConst1>		; 0xD1
	TOpcodeData	<0, kShfOp, argRegMem8, argRegCL>		; 0xD2
	TOpcodeData	<0, kShfOp, argRegMem16, argRegCL>		; 0xD3
	TOpcodeData	<s_mAAM, kNormal, argImm8, argNone>		; 0xD4
	TOpcodeData	<s_mAAD, kNormal, argImm8, argNone>		; 0xD5
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xD6
	TOpcodeData	<s_mXLAT, kNormal, argNone, argNone>		; 0xD7
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xD8
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xD9
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xDA
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xDB
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xDC
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xDD
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xDE
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xDF
	TOpcodeData	<s_mLOOPNZ, kNormal, argShort, argNone>		; 0xE0
	TOpcodeData	<s_mLOOPZ, kNormal, argShort, argNone>		; 0xE1
	TOpcodeData	<s_mLOOP, kNormal, argShort, argNone>		; 0xE2
	TOpcodeData	<s_mJCXZ, kNormal, argShort, argNone>		; 0xE3
	TOpcodeData	<s_mIN, kNormal, argRegAL, argImm8>		; 0xE4
	TOpcodeData	<s_mIN, kNormal, argRegAX, argImm8>		; 0xE5
	TOpcodeData	<s_mOUT, kNormal, argImm8, argRegAL>		; 0xE6
	TOpcodeData	<s_mOUT, kNormal, argImm8, argRegAX>		; 0xE7
	TOpcodeData	<s_mCALL, kNormal, argNear, argNone>		; 0xE8
	TOpcodeData	<s_mJMP, kNormal, argNear, argNone>		; 0xE9
	TOpcodeData	<s_mJMP, kNormal, argFar, argNone>		; 0xEA
	TOpcodeData	<s_mJMP, kNormal, argShort, argNone>		; 0xEB
	TOpcodeData	<s_mIN, kNormal, argRegAL, argRegDX>		; 0xEC
	TOpcodeData	<s_mIN, kNormal, argRegAX, argRegDX>		; 0xED
	TOpcodeData	<s_mOUT, kNormal, argRegDX, argRegAL>		; 0xEE
	TOpcodeData	<s_mOUT, kNormal, argRegDX, argRegAX>		; 0xEF
	TOpcodeData	<s_mLOCK, kPrefix, argNone, argNone>		; 0xF0
	TOpcodeData	<0, kNormal, argNone, argNone>			; 0xF1
	TOpcodeData	<s_mREPNE, kPrefix, argNone, argNone>		; 0xF2
	TOpcodeData	<s_mREP, kPrefix, argNone, argNone>		; 0xF3
	TOpcodeData	<s_mHLT, kNormal, argNone, argNone>		; 0xF4
	TOpcodeData	<s_mCMC, kNormal, argNone, argNone>		; 0xF5
	TOpcodeData	<0, kGrp1, argRegMem8, argNone>			; 0xF6
	TOpcodeData	<0, kGrp1, argRegMem16, argNone>		; 0xF7
	TOpcodeData	<s_mCLC, kNormal, argNone, argNone>		; 0xF8
	TOpcodeData	<s_mSTC, kNormal, argNone, argNone>		; 0xF9
	TOpcodeData	<s_mCLI, kNormal, argNone, argNone>		; 0xFA
	TOpcodeData	<s_mSTI, kNormal, argNone, argNone>		; 0xFB
	TOpcodeData	<s_mCLD, kNormal, argNone, argNone>		; 0xFC
	TOpcodeData	<s_mSTD, kNormal, argNone, argNone>		; 0xFD
	TOpcodeData	<0, kGrp2, argRegMem8, argNone>			; 0xFE
	TOpcodeData	<0, kGrp3, argRegMem16, argNone>		; 0xFF

; Opcode groups

label	sa_ArOp		word
		dw	s_mADD	; 0
		dw	s_mOR	; 1
		dw	s_mADC	; 2
		dw	s_mSBB	; 3
		dw	s_mAND	; 4
		dw	s_mSUB	; 5
		dw	s_mXOR	; 6
		dw	s_mCMP	; 7

label	sa_Grp1		word
		dw	s_mTEST	; 0	r/m,imm
		dw	0	; 1
		dw	s_mNOT	; 2
		dw	s_mNEG	; 3
		dw	s_mMUL	; 4
		dw	s_mIMUL	; 5
		dw	s_mDIV	; 6
		dw	s_mIDIV	; 7

label	sa_Grp2		word
		dw	s_mINC	; 0
		dw	s_mDEC	; 1
		dw	0	; 2
		dw	0	; 3
		dw	0	; 4
		dw	0	; 5
		dw	0	; 6
		dw	0	; 7

label	sa_Grp3		word
		dw	s_mINC	; 0
		dw	s_mDEC	; 1
		dw	s_mCALL	; 2	word
		dw	s_mCALL	; 3	dword
		dw	s_mJMP	; 4	word
		dw	s_mJMP	; 5	dword
		dw	s_mPUSH	; 6
		dw	0	; 7

label	sa_ShfOp	word
		dw	s_mROL	; 0
		dw	s_mROR	; 1
		dw	s_mRCL	; 2
		dw	s_mRCR	; 3
		dw	s_mSHL	; 4
		dw	s_mSHR	; 5
		dw	0	; 6
		dw	s_mSAR	; 7


Groups		dw	sa_ArOp, sa_Grp1, sa_Grp2, sa_Grp3, sa_ShfOp

