#!/usr/bin/perl -w
# $Id: opasm.pl,v 1.2 1999/10/08 11:59:33 mg Exp $
use strict;

my %ArgHash = (
 'r/m8' => 'argRegMem8',
 'r/m16' => 'argRegMem16',
 'r8' => 'argReg8',
 'r16' => 'argReg16',
 'seg' => 'argSegReg',
 'AL' => 'argRegAL', 'BL' => 'argRegBL', 'CL' => 'argRegCL', 'DL' => 'argRegDL',
 'AH' => 'argRegAH', 'BH' => 'argRegBH', 'CH' => 'argRegCH', 'DH' => 'argRegDH',
 'AX' => 'argRegAX', 'BX' => 'argRegBX', 'CX' => 'argRegCX', 'DX' => 'argRegDX',
 'SP' => 'argRegSP', 'BP' => 'argRegBP', 'SI' => 'argRegSI', 'DI' => 'argRegDI',
 'CS' => 'argRegCS', 'DS' => 'argRegDS', 'SS' => 'argRegSS', 'ES' => 'argRegES',
 'mem8' => 'argMem8',
 'mem16' => 'argMem16',
 'mem32' => 'argMem32',
 'memoffs8' => 'argMemOffs8',
 'memoffs16' => 'argMemOffs16',
 'near' => 'argNear',
 'far' => 'argFar',
 'short' => 'argShort',
 'imm8' => 'argImm8',
 'imm16' => 'argImm16',
 'simm8' => 'argSImm8',
 '1' => 'argConst1',
 '3' => 'argConst3',
 'prefix' => 'argNone',
 );

my (%Opcodes, %BadArgs, %MoreOps, %Mnems);

while (<>) {
    chomp;
    if (/^([0-9a-fA-F]{2})\s+(\S+)(?:\s+([^, \t]+)(?:,(\S+))?)?/) {
	$Opcodes{hex($1)}{MNEMONIC} = $2;
	$Opcodes{hex($1)}{ARG1} = $3 || '';
	$Opcodes{hex($1)}{ARG2} = $4 || '';
	$BadArgs{$3} = 1 if defined $3 && !defined $ArgHash{$3};
	$BadArgs{$4} = 1 if defined $4 && !defined $ArgHash{$4};
	$Mnems{$2}++ if $2 && $2 !~ /^</;
    } elsif (/^;\s*<([^>]+)>:/) {
	my $Op = $1;
        for my $i (0..7) {
	    chomp ($_ = <>);
	    if (/^;\s*([0-1]{3})(?:\s+(\S+)\s*((?<=\s)[^;]\S*)?)?/) {
		$MoreOps{$Op}[$i]{MNEMONIC} = $2 || '';
		$MoreOps{$Op}[$i]{ARGS} = $3 || '';
		$Mnems{$2}++ if $2;
	    }
	}
    }
}

print "; Kinds\n";
my $i = 2;
for my $op (sort keys %MoreOps) {
    print "k$op\t\tequ\t$i\n";
    $i++;
}

print "\n; Mnemonics\n";
for my $m (sort keys %Mnems) {
    my $mn_label = "s_m" . uc($m);
#    if ($m =~ /^seg[cdes]s$/) {
#    	print $mn_label, length($mn_label) < 8? "\t" : "", "\tdb\t0\t; don't output\n";
#    } else {
    	print $mn_label, length($mn_label) < 8? "\t" : "", "\tdb\t'$m', 0\n";
#    }
    $Mnems{$m} = $mn_label;
}

print "\n; Opcodes\n";
print "Opcodes\t\tlabel\tTOpcodeData\n"	if 0;
print "label\tOpcodes\tTOpcodeData\n" if 1;

for (my $i = 0; $i < 256; $i++) {
    my $op = $Opcodes{$i};
    $op = {MNEMONIC => '', ARG1 => '', ARG2 => ''} unless defined $op;
    my $mn = $op->{MNEMONIC};
    my $kind = $op->{ARG1} eq "prefix" ? "kPrefix" : "kNormal";
    if ($mn) {
	if (defined $Mnems{$mn}) {
	    $mn = $Mnems{$mn};
	} else {
	    for ($kind = $mn) {
		s/^</k/;
		s/>$//;
	    }
	    $mn = "0";
	}
    } else {
	$mn = "0";
    }
    my $s = "<" . $mn . ", " . $kind . ", " .
          (defined $ArgHash{$op->{ARG1}} ? $ArgHash{$op->{ARG1}} : "argNone") .
	  ", " .
          (defined $ArgHash{$op->{ARG2}} ? $ArgHash{$op->{ARG2}} : "argNone") .
	  ">";
    print "\tTOpcodeData\t", $s, "\t" x (7 - (length($s)+1) / 8), "; 0x", sprintf("%02X", $i), "\n";
}

if (keys %BadArgs) {
    print "\n;* Invalid arguments: ",
          join("\n;* ", '', sort keys %BadArgs),
	  "\n\n";
   
}

print "\n; Opcode groups\n";
for my $op (sort keys %MoreOps) {
    print "\nlabel\tsa_$op", "\t" x (3 - length("sa_$op ") / 8), "word\n";
    for my $i (0..7) {
	print "\t\tdw\t";
	print $Mnems{$MoreOps{$op}[$i]{MNEMONIC}} || "0";
	print "\t; $i";
	print "\t$MoreOps{$op}[$i]{ARGS}" if $MoreOps{$op}[$i]{ARGS};
	print "\n";
    }
}
print "\n\nGroups\t\tdw\tsa_", join(", sa_", sort keys %MoreOps), "\n\n";

