{ Advanced\XmasTree - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    A fractal Christmas tree.

    Task.       You should be able to improve on this crude example
                quite easily.
}

unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  TFormMain = class(TForm)
    PaintBox1: TPaintBox;
    Timer1: TTimer;
    procedure PaintBox1Paint(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure land;
    Procedure sky;
    Procedure snowman;
    Procedure snow;
    Procedure tree(x, y, s : Integer);
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

Procedure TFormMain.tree(x, y, s : Integer);
Var c : Word;
Begin
  paintBox1.canvas.pen.color := clGreen;

  If s > 0 Then
  Begin
    paintBox1.canvas.pen.width := s div 10;

    paintBox1.canvas.moveto(x, y);
    paintBox1.canvas.lineto(x, y - s);

    paintBox1.canvas.moveto(x - s, y - s div 2);
    paintBox1.canvas.lineto(x + s, y - s div 2);

    tree(x, y - s, 2 * (s div 3));
    tree(x - s, y - s div 2, (s div 2));
    tree(x + s, y - s div 2, (s div 2));
  End
End;

Procedure TFormMain.land;
begin
  paintBox1.canvas.brush.color := clSilver;
  paintBox1.canvas.pen.color := clSilver;
  paintBox1.canvas.rectangle(0, 3 * paintBox1.height div 4,
                             paintBox1.width, paintBox1.height)
end;

Procedure TFormMain.sky;
begin
  paintBox1.canvas.brush.color := clBlue;
  paintBox1.canvas.pen.color := clBlue;
  paintBox1.canvas.rectangle(0, 0,
                             paintBox1.width, 3 * paintBox1.height div 4)
end;

Procedure TFormMain.snowman;
begin
end;

Procedure TFormMain.snow;
begin
end;

procedure TFormMain.PaintBox1Paint(Sender: TObject);
begin
  land;
  sky;
  tree(PaintBox1.Height, PaintBox1.Height, PaintBox1.Height div 3);
  snowman;
  snow
end;

procedure TFormMain.Timer1Timer(Sender: TObject);
begin
  paintBox1.Canvas.Pixels[random(paintBox1.Width), random(paintBox1.height)] := clWhite
end;

end.
