{ Advanced\Verify_W - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    A crude and incomplete HTML checker.

    Task.       Write your own web pages and get them checked with
                professionally written tools.
}

unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, ExtCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    ListBox1: TListBox;
    Button1: TButton;
    procedure FileListBox1DblClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    textLength : Integer;
    pushCount  : Integer;
    theFile    : String;

    procedure CheckHTML;
    procedure push(s : String);
    function  pop : String;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.push(s : String);
begin
  if s = 'BR'  then exit;
  if s = 'HR'  then exit;
  if s = 'P'   then exit;
  if s = 'LI'  then exit;
  if s = 'IMG' then exit;

  pushCount := pushCount + 1;

  if (pushCount = 1) AND (S <> 'HTML') then
  begin
    messageDlg('<HTML> is expected at the start of your document.', mtWarning, [mbOK], 0)
  end;

  if (pushCount = 2) AND (S <> 'HEAD') then
  begin
    messageDlg('<HEAD> is expected after <HTML> at the start of your document.', mtWarning, [mbOK], 0)
  end;

  if (pushCount = 3) AND (S <> 'TITLE') then
  begin
    messageDlg('<TITLE> is expected after <HEAD> at the start of your document.', mtWarning, [mbOK], 0)
  end;

  listBox1.Items.Add(s);
  listBox1.update
end;

function  TForm1.pop : String;
var s : String;
begin
  if ListBox1.Items.Count > 0 then
  begin
    s := listBox1.Items[ListBox1.Items.Count - 1];
    listBox1.Items.Delete(ListBox1.Items.Count - 1);
    listBox1.update
  end
  else
  begin
    messageDlg('You have one or more missing closing tags.', mtError, [mbOK], 0)
  end;

  result := s
end;

procedure TForm1.CheckHTML;
Var i      : Integer;
    tok    : string;
    was    : string;
    cop    : boolean;
    copFF  : boolean;
    copFn  : Integer;
begin
  listBox1.Clear;
  memo1.selstart := 0;
  memo1.selectAll;
  memo1.setFocus;
  pushCount  := 0;
  textLength := memo1.selLength;
  cop        := false;
  tok        := '';
  copFF      := false;
  copFn      := 0;

  for i := 0 to textLength - 1 do
  begin
    memo1.selstart := i;
    memo1.selLength := 1;

    if (not copFF) AND (memo1.selText = '"') then
    begin
      copFF := true
    end;

    if memo1.selText = '<' then
    begin
      cop := true
    end;

    if copFF then
    begin
      copFn := copFn + 1;

      if copFn > 15 then
      begin
        copFn := 0;
        copFF := False
      end
      else
      begin
        if (copFn <> 1) AND (memo1.selText = '"') then
        begin
          copFn := 0;
          copFF := False
        end
        else
        begin
          if (memo1.selText >= 'A') AND (memo1.selText <= 'Z') then
          begin
            messageDlg('Warning : Possible uppercase character in a file name.', mtWarning, [mbOK], 0)
          end
        end
      end
    end;

    if cop then
    begin
      if (memo1.selText = ' ') OR
         (memo1.selText = '<') OR
         (memo1.selText = '>') then
      begin
        { Yes : Do nothing }
      end
      else
      begin
        tok := tok + memo1.selText
      end
    end;

    if cop AND ((memo1.selText = '>') OR (memo1.selText = ' ')) then
    begin
      cop := false;
      if length(tok) > 0 then
      begin
        if tok[1] = '/' then
        begin
          tok := uppercase(copy(tok, 2, length(tok) - 1));
          was := pop;
          if was <> tok then
          begin
            messageDlg('Error : /' + tok + ' does not match ' + was + '.', mtError, [mbOK], 0)
          end
        end
        else
        begin
          push(uppercase(tok));
        end
      end;

      tok := ''
    end

  end;

  if listBox1.Items.Count > 0 then
  begin
    messageDlg('A closing tag is missing.', mtError, [mbOK], 0);
    memo1.setFocus
  end
end;

procedure TForm1.FileListBox1DblClick(Sender: TObject);
begin
  theFile := FileListBox1.fileName;
  caption := theFile;
  memo1.lines.loadFromFile(theFile);
  CheckHTML
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if theFile <> '' then
    memo1.lines.saveToFile(theFile)
  else
    messageDlg('File not saved.', mtError, [mbOK], 0)
end;

end.
