{ Advanced\TreeWalk - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    This may not work correctly with long file names!
                Re-write this with Delphi 2+.

                A Tree Walker.  Use this to visit and process every
                file and directory in a tree.  Use with caution.  This
                could damage every file if written badly!

                This version visits the files and directories but
                does nothing to them.

                The program might fail if a directory or file is
                deleted after the file is listed but before it gets
                processed.

    Task.       Use this to search for a named file in a directory tree.
}

unit Tree_f;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Timer1: TTimer;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    ButtonClose: TButton;
    procedure Timer1Timer(Sender: TObject);
    procedure ButtonCloseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure getFiles(aDir : String);
    procedure push(aFile : String);
    procedure process(aFile : String);
    function  pop : String;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  { If there is nothing stored then start. }
  if listBox1.Items.Count = 0 then
  begin
    { This is the starting point. }
    { For example    P:\ }
    { For example    F:\Winwork\Delphi\ }
    { Or try the line below. }
    { This could come from an edit control or a file open dialog. }
    getFiles('C:\');
  end
  else { Else return the stored data. }
  begin
    process(pop);
  end
end;

procedure TForm1.getFiles(aDir : String);
Var F : TSearchRec;
    N : Integer;
begin
  label1.caption := aDir;

  { Find all the files in the specified directory (aDir). }
  N := FindFirst(aDir + '*.*', faAnyFile, F);
  While N = 0 Do
  begin
    if F.Attr = faDirectory then
    begin
      { If it is a directory, add a '/' to the name. }
      push(aDir + F.Name + '\')
    end
    else
    begin
      { If it is a file, store the name as it is. }
      push(aDir + F.Name)
    end;

    N := findNext(F)
  end;
end;

procedure TForm1.push(aFile : String);
begin
  listBox1.Items.Add(aFile);

  { Make the listbox display keep track of wat is happening. }
  listBox1.ItemIndex := listBox1.Items.Count - 1;

  { Display the item count.  This should not grow uncontrolably large. }
  label2.caption := intToStr(listBox1.Items.Count);
end;

procedure TForm1.process(aFile : String);
begin
  { If it is a directory, do the getFiles operation. }
  { If the last character is a '\' then is is a directory. }
  if aFile[length(aFile)] = '\' then
  begin
    getFiles(aFile)
  end
  else
  begin
    { Process the file in some way.  This program does               }
    { nothing the the files.  You could delete, copy, backup, search }
    { or do something else to the file. }
  end
end;

function TForm1.pop : String;
begin
  if listBox1.Items.Count = 0 then
  begin
    { Return Error Message.  Never happens if }
    { the program is under control.           }
    pop := 'Stack Underflow'
  end
  else
  begin
    { Return last item in the list box. }
    pop := listBox1.Items[listBox1.Items.Count - 1];

    { Delete last item in the list box. }
    listBox1.Items.delete(listBox1.Items.Count - 1);
    listBox1.ItemIndex := listBox1.Items.Count - 1;
    label2.caption := intToStr(listBox1.Items.Count);
  end
end;

procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
  Close
end;

end.
