{ Advanced\STR_CUT - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    A program to extract sub strings out of a bigger string.

    Task.       You should be able to take apart and re-assemble text
                strings in any way you need to.

                For example.  Use the timeToStr(time) functions to
                get the time of day.  Extract the hours, minutes and
                seconds separately from the text string returned.
                Display the results on labels.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TFormMain = class(TForm)
    EditInput: TEdit;
    LabelInput: TLabel;
    LabelSeparator: TLabel;
    EditSeparator: TEdit;
    ButtonHead: TButton;
    ButtonTail: TButton;
    LabelResult: TLabel;
    LabelResultValue: TLabel;
    ButtonPrint: TButton;
    procedure ButtonHeadClick(Sender: TObject);
    procedure ButtonTailClick(Sender: TObject);
    procedure ButtonPrintClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    function headOf(someText, separatorChar : String) : String;
    function tailOf(someText, separatorChar : String) : String;
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

{ ----------------------------------------------------------------- }
{
  name:     headOf
  inputs:   someText      - this is any text string to be split
            separatorChar - a single character to mark the split position
  process:  locate the position of the marker character
            extract the text before the marker character
  output:   the text before the marker character
}
function TFormMain.headOf(someText, separatorChar : String) : String;
Var positionOfSeparatorChar : Integer;
begin
  { use pos to find the position of the marker character }
  positionOfSeparatorChar := pos(separatorChar, someText);

  if positionOfSeparatorChar = 0 then
  begin                      { Separator character was not found }
    result := ''             { Result is a string with no text in it }
  end
  else                       { Separator character was found }
  begin                      { Result is the text before the separator }
    result := copy(someText, 1, positionOfSeparatorChar - 1)
  end
end;

{ ----------------------------------------------------------------- }
{
  name:     tailOf
  inputs:   someText      - this is any text string to be split
            separatorChar - a single character to mark the split position
  process:  locate the position of the marker character
            find the length of the text to be split
            extract the text after the space after the marker character
  output:   the text after the space after the marker character
}
function TFormMain.tailOf(someText, separatorChar : String) : String;
Var positionOfSeparatorChar : Integer;
    lengthOfText            : Integer;
begin
  { use pos to find the position of the marker character }
  positionOfSeparatorChar := pos(separatorChar, someText);

  { use length to find the length of the text to be split }
  lengthOfText            := length(someText);

  if positionOfSeparatorChar = 0 then
  begin            { Separator character was not found }
    result := ''   { Result is a string with no text in it }
  end
  else             { Separator character was found }
  begin            { result is text after the space after the separator }
    result := copy(someText,
                   positionOfSeparatorChar + 2,
                   lengthOfText - positionOfSeparatorChar - 1)
  end
end;

{ ----------------------------------------------------------------- }
{
  Test the headOf function.

  The text is shown enclosed between >these< characters.  This guarantees
  that any unexpected characters or spaces in the result are visible.
}
procedure TFormMain.ButtonHeadClick(Sender: TObject);
begin
  { Set the label caption to the result returned by the headOf function }
  LabelResultValue.Caption := '>' +
                              headOf(EditInput.Text, editSeparator.Text) +
                              '<'
end;

{ ----------------------------------------------------------------- }
{
  Test the tailOf function.

  The text is shown enclosed between >these< characters.  This guarantees
  that any unexpected characters or spaces in the result are visible.
}
procedure TFormMain.ButtonTailClick(Sender: TObject);
begin
  { Set the label caption to the result returned by the tailOf function }
  LabelResultValue.Caption := '>' +
                              tailOf(EditInput.Text, editSeparator.Text) +
                              '<'
end;

{ ----------------------------------------------------------------- }
{
  Print the form.  This is useful for screen shot evidence.
  This technique is simpler than using PrintScreen but the
  screen print out can not be included into a word document.
}
procedure TFormMain.ButtonPrintClick(Sender: TObject);
begin
  Print
end;

end.

{ ----------------------------------------------------------------- }

