{ Advanced\Stack - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.   THE STACK - This program uses a listBox to
               make the stack visible.

               Items are pushed onto the end of the stack.
               Items are popped off the end of the stack.
               Last In First Out  LIFO.

               The stack is an array of pointers to TStackNodes
               TStackNode can be designed to hold any type of data.

               The limit of five for the stack size can be
               altered by changing the constant MAXSTACK below.

    Task.      Use this stack to store single text characters in
               order to reverse the input text.  If you type in
               Hello! it should reply with !olleH.  Use an edit
               control to input your text.  Extract and push
               single text characters from the input string.
}

unit Stakform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

Const
  MAXSTACK = 5;     { Alter this to get a bigger or smaller stack    }

type
  TStackNode = class(TObject)
    item : String;  { If necessary, this object could be much more complex! }
  end;

  TFormStack = class(TForm)
    ListBoxStack: TListBox;
    LabelStack: TLabel;
    ButtonPush: TButton;
    EditStack: TEdit;
    ButtonPop: TButton;
    LabelSPLabel: TLabel;
    LabelSP: TLabel;
    LabelPopLabel: TLabel;
    LabelPop: TLabel;
    Label1: TLabel;
    procedure ButtonPushClick(Sender: TObject);
    procedure ButtonPopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    theStack : array[0..MAXSTACK - 1] of TStackNode;
    SP       : Integer;          { The Stack Pointer }

    procedure push(anItem : String);
    procedure updateDisplay;

    function  pop : String;
  end;

var
  FormStack: TFormStack;

implementation

{$R *.DFM}

{ ------------------------------------------- }

procedure TFormStack.updateDisplay;
Var i : Integer;
begin
  listBoxStack.Clear;                       { This is only done to make }
  for i := MAXSTACK - 1 downto 0 do         { the stack visible.        }
  begin
    if theStack[i] <> Nil then
    begin
      listBoxStack.Items.Add(theStack[i].item)
    end
  end;

  labelSP.Caption := intToStr(SP);
  labelSP.Caption := intToStr(SP)
end;

{ ------------------------------------------- }

procedure TFormStack.push(anItem : String);
begin
  if SP < MAXSTACK then
  begin
    theStack[SP] := TStackNode.Create;
    theStack[SP].item := anItem;
    SP := SP + 1
  end
  else
  begin
    messageDlg('STACK OVERFLOW', mtError, [mbOK], 0)
  end;

  updateDisplay
end;

{ ------------------------------------------- }

function  TFormStack.pop : String;
begin
  if SP > 0 then
  begin
    SP := SP - 1;
    result := theStack[SP].Item;
    theStack[SP].Free;
    theStack[SP] := Nil
  end
  else
  begin
    messageDlg('STACK UNDERFLOW', mtError, [mbOK], 0);
    result := ''
  end;

  updateDisplay
end;

{ ------------------------------------------- }

procedure TFormStack.ButtonPushClick(Sender: TObject);
begin
  if editStack.Text <> '' then
  begin
    push(editStack.Text)
  end;

  editStack.setFocus;
  editStack.selectAll
end;

{ ------------------------------------------- }

procedure TFormStack.ButtonPopClick(Sender: TObject);
begin
  labelPop.Caption := pop;

  editStack.setFocus;
  editStack.selectAll
end;

{ ------------------------------------------- }

procedure TFormStack.FormCreate(Sender: TObject);
Var i : Integer;
begin
  SP := 0;

  for i := 0 to MAXSTACK - 1 do
  begin
    theStack[i] := Nil
  end;

  updateDisplay
end;

{ ------------------------------------------- }

procedure TFormStack.FormDestroy(Sender: TObject);
begin
  while SP > 0 Do             { Keep popping until SP = 0         }
  begin                       { This frees allocated memory       }
    pop                       { This guarantees that your program }
  end                         { will not leak memory              }
end;

end.

{ ------------------------------------------- }

