{ Advanced\Sorts - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    Insertion sort is timed.

    Task.       Write and time bubble sort and quick sort.
                Compare the performance of the sorting methods
                on random data, semi sorted data and sorted data.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

Const Max = 5000;

type
  TForm1 = class(TForm)
    PanelTop: TPanel;
    ButtonBubble: TButton;
    Memo: TMemo;
    PanelRight: TPanel;
    ButtonInsertion: TButton;
    ButtonQuick: TButton;
    LabelStart: TLabel;
    LabelEnd: TLabel;
    LabelDuration: TLabel;
    LabelStartValue: TLabel;
    LabelEndValue: TLabel;
    LabelDurationValue: TLabel;
    LabelNumCount: TLabel;
    LabelNumCountValue: TLabel;
    procedure ButtonBubbleClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ButtonInsertionClick(Sender: TObject);
    procedure ButtonQuickClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    data   : array[1..Max] of Integer;
    start  : TDateTime;
    finish : TDateTime;

    procedure randomise;
    procedure updateMemo;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.updateMemo;
Var i : Integer;
begin
  LabelNumCountValue.Caption    := intToStr(Max);
  LabelStartValue.Caption       := TimeToStr(Start);
  LabelEndValue.Caption         := TimeToStr(Finish);
  LabelDurationValue.Caption    := TimeToStr(Finish - Start);

  memo.clear;

  for i := 1 to 30 do
  begin
    if i <= max then memo.lines.add(intToStr(data[i]))
  end;

  memo.lines.add('Skipped some data here.');

  for i := Max - 30 to Max do
  begin
    if (i > 30) AND (i  <= max) then memo.lines.add(intToStr(data[i]))
  end;
end;

{ ---------------------------------------------------------------------- }

procedure TForm1.randomise;
Var i : Integer;
begin
  for i := 1 to Max do
  begin
    data[i] := random(32767)
  end;

  updateMemo;
end;

{ ---------------------------------------------------------------------- }
{
    Bubble sort is the least efficient method of sorting.

    Repeatedly scan the data and if necessary, swap pairs of numbers
    until all are sorted.

    TASK

    Write this procedure.
}
procedure TForm1.ButtonBubbleClick(Sender: TObject);
begin
  messageDlg('It is your task to write bubble sort.', mtInformation, [mbOK], 0)
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  updateMemo;
end;

{ ---------------------------------------------------------------------- }
{
    Insertion sort.

    Working from left to right, extract each number in turn.  The
    left most number does not need to be extracted.

    Working from the gap towards the left, shift each number along
    one place to the right until the correct insertion position is
    found.  Insert the extracted number.

    Do this until all the numbers have been extracted and put back in
    in the correct position.
}
procedure TForm1.ButtonInsertionClick(Sender: TObject);
Var Temp, i, j : Integer;
begin
  randomise;             { Generate the random numbers. }

  start := time;

  for i := 2 to Max do   { Scan from left to right.  Not first number. }
  begin
    temp := data[i];               { Extract each number. }

    for j := i - 1 downto 1 do     { Scan left from the gap. }
    begin
      if temp >= data[j] then      { At the correct insertion position }
      begin
        data[j + 1] := temp;       { Insert the extracted number }
        break                      { Skip the rest of this loop }
      end
      else
      begin                        { Move each number along one place }
        data[j + 1] := data[j]
      end;

      if j = 1 then                { Havn't found the place to insert }
      begin                        { so it must go into position one }
        data[j] := temp
      end
    end
  end;

  finish := time;
  updateMemo;
end;

procedure TForm1.ButtonQuickClick(Sender: TObject);
begin
  messageDlg('It is your task to write quick sort.', mtInformation, [mbOK], 0)
end;

end.
