{ Advanced\SortAnim - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    Sorting algorithms made visible.

    Task.       Research some other sorting algorithms
                and add them to this program.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, MPlayer;

type
  TForm1 = class(TForm)
    ButtonSort: TButton;
    ButtonDual: TButton;
    ButtonInsertion: TButton;
    ButtonQuick: TButton;
    ButtonSlowMo: TButton;
    ButtonShell: TButton;
    ButtonShellSlo: TButton;
    procedure ButtonSortClick(Sender: TObject);
    procedure ButtonDualClick(Sender: TObject);
    procedure ButtonInsertionClick(Sender: TObject);
    procedure ButtonQuickClick(Sender: TObject);
    procedure ButtonSlowMoClick(Sender: TObject);
    procedure ButtonShellClick(Sender: TObject);
    procedure ButtonShellSloClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    data   : array[0..1023] of Integer;
    aColor : TColor;
    delay  : Boolean;

    procedure doLine(i, height : Integer; color : TColor);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.doLine(i, height : Integer; color : TColor);
Var k : LongInt;
begin
  if delay then for k := 1 to 50000 do;
  canvas.pen.color := color;
  canvas.moveTo(i, form1.clientheight);
  canvas.lineTo(i, form1.clientheight - height);
  canvas.pen.color := clBtnFace;
  canvas.lineTo(i, 0);
end;

procedure TForm1.ButtonSortClick(Sender: TObject);
Var i, swap, limit : Integer;
    allSorted      : Boolean;
begin
  delay := false;
  for i := 1 to form1.clientWidth - 2 do
  begin
    data[i] := random(form1.clientHeight);
    doLine(i, data[i], clBlue)
  end;

  limit := form1.clientWidth - 3;

  repeat
    allSorted := true;

    for i := 1 to limit do
    begin
      if data[i] > data[i + 1] then
      begin
        swap := data[i];
        data[i] := data[i + 1];
        data[i + 1] := swap;
        allSorted := false;
        doLine(i, data[i], clBlack);
        doLine(i + 1, data[i + 1], clBlack)
      end
    end;

    limit := limit - 1
  until allSorted
end;

procedure TForm1.ButtonDualClick(Sender: TObject);
Var i, swap, ulimit, llimit : Integer;
    allSorted               : Boolean;
begin
  delay := false;
  for i := 1 to form1.clientWidth - 2 do
  begin
    data[i] := random(form1.clientHeight);
    doLine(i, data[i], clBlue)
  end;

  ulimit := form1.clientWidth - 2;
  llimit := 1;

  repeat
    allSorted := true;

    for i := llimit to ulimit - 1 do
    begin
      if data[i] > data[i + 1] then
      begin
        swap := data[i];
        data[i] := data[i + 1];
        data[i + 1] := swap;
        allSorted := false;
        doLine(i, data[i], clBlack);
        doLine(i + 1, data[i + 1], clBlack)
      end
    end;
    ulimit := ulimit - 1;
    if allSorted then exit;

    allSorted := true;
    for i := ulimit downto llimit + 1 do
    begin
      if data[i - 1] > data[i] then
      begin
        swap := data[i];
        data[i] := data[i - 1];
        data[i - 1] := swap;
        allSorted := false;
        doLine(i, data[i], clBlack);
        doLine(i - 1, data[i - 1], clBlack)
      end
    end;

    llimit := llimit + 1
  until allSorted
end;

procedure TForm1.ButtonInsertionClick(Sender: TObject);
Var Temp, i, j : Integer;
begin
  delay := false;
  for i := 1 to form1.clientWidth - 1 do
  begin
    data[i] := random(form1.clientHeight);
    doLine(i, data[i], clBlue)
  end;

  for i := 2 to form1.clientWidth - 1 do
                          { Scan from left to right.  Not first number. }
  begin
    temp := data[i];               { Extract each number. }

    for j := i - 1 downto 1 do     { Scan left from the gap. }
    begin
      if temp >= data[j] then      { At the correct insertion position }
      begin
        data[j + 1] := temp;       { Insert the extracted number }
        doLine(j + 1, data[j + 1], clBlack);
        break                      { Skip the rest of this loop }
      end
      else
      begin                        { Move each number along one place }
        data[j + 1] := data[j];
        doLine(j + 1, data[j], clBlack)
      end;

      if j = 1 then                { Havn't found the place to insert }
      begin                        { so it must go into position one }
        data[j] := temp;
        doLine(j, data[j], clBlack)
      end
    end
  end;
end;

procedure TForm1.ButtonQuickClick(Sender: TObject);

        procedure Sort(l, r: Integer);
        var
          i, j, x, y: integer;
        begin
          i := l; j := r; x := data[(l+r) DIV 2];
          repeat
            while data[i] < x do i := i + 1;
            while x < data[j] do j := j - 1;
            if i <= j then
            begin
              y := data[i];
              data[i] := data[j];
              doLine(i, data[i], clRed);
              data[j] := y;
              doLine(j, data[j], clYellow);
              i := i + 1;
              j := j - 1;
            end;
          until i > j;
          if i < r then Sort(i, r);
          if l < j then Sort(l, j);
        end;

Var Temp, i, j : Integer;
begin
  delay := false;

  for i := 1 to form1.clientWidth - 2 do
  begin
    data[i] := random(form1.clientHeight);
    doLine(i, data[i], clBlue)
  end;

  sort(1, form1.clientWidth - 2)
end;

procedure TForm1.ButtonSlowMoClick(Sender: TObject);

        procedure Sort(l, r: Integer);
        var
          i, j, x, y: integer;
        begin
          i := l; j := r; x := data[(l+r) DIV 2];
          repeat
            while data[i] < x do i := i + 1;
            while x < data[j] do j := j - 1;
            if i <= j then
            begin
              y := data[i];
              data[i] := data[j];
              doLine(i, data[i], clRed);
              data[j] := y;
              doLine(j, data[j], clYellow);
              i := i + 1;
              j := j - 1;
            end;
          until i > j;
          if i < r then Sort(i, r);
          if l < j then Sort(l, j);
        end;

Var Temp, i, j : Integer;
begin
  delay := true;

  for i := 1 to form1.clientWidth - 2 do
  begin
    data[i] := random(form1.clientHeight);
    doLine(i, data[i], clBlue)
  end;

  sort(1, form1.clientWidth - 2)
end;

procedure TForm1.ButtonShellClick(Sender: TObject);
var distance,
    Items,
    temp,
    marker1,
    marker2,
    marker3,
    marker4, i : Integer;

                procedure swap;
                begin
                  temp := data[marker1];
                  data[marker1] := data[marker2];
                  data[marker2] := temp;
                  doLine(marker1, data[marker1], clRed);
                  doLine(marker2, data[marker2], clRed);

                  marker4 := marker1;
                  marker3 := marker1 - distance;

                  while (marker3 > 0) AND
                        (data[marker3] > data[marker4]) do
                  begin
                    temp := data[marker3];
                    data[marker3] := data[marker4];
                    data[marker4] := temp;
                    doLine(marker3, data[marker3], clLime);
                    doLine(marker4, data[marker4], clLime);
                    marker3 := marker3 - distance;
                    marker4 := marker4 - distance
                  end
                end;

begin
  delay := false;

  for i := 1 to form1.clientWidth - 2 do  { MAKE RANDOM NUMBERS }
  begin
    data[i] := random(form1.clientHeight);
    doLine(i, data[i], clBlue)
  end;

  Items := form1.clientWidth - 2;

  distance := Items;
  repeat
    marker1 := 1;
    distance := trunc(distance / 2);
    marker2 := marker1 + distance;
    repeat
      if data[marker1] > data[marker2] then swap;
      marker1 := marker1 + 1;
      marker2 := marker2 + 1;
    until marker2 > Items;
  until distance = 1;
end;

procedure TForm1.ButtonShellSloClick(Sender: TObject);
var distance,
    Items,
    temp,
    marker1,
    marker2,
    marker3,
    marker4, i : Integer;

                procedure swap;
                begin
                  temp := data[marker1];
                  data[marker1] := data[marker2];
                  data[marker2] := temp;
                  doLine(marker1, data[marker1], clRed);
                  doLine(marker2, data[marker2], clRed);

                  marker4 := marker1;
                  marker3 := marker1 - distance;

                  while (marker3 > 0) AND
                        (data[marker3] > data[marker4]) do
                  begin
                    temp := data[marker3];
                    data[marker3] := data[marker4];
                    data[marker4] := temp;
                    doLine(marker3, data[marker3], clLime);
                    doLine(marker4, data[marker4], clLime);
                    marker3 := marker3 - distance;
                    marker4 := marker4 - distance
                  end
                end;

begin
  delay := true;

  for i := 1 to form1.clientWidth - 2 do  { MAKE RANDOM NUMBERS }
  begin
    data[i] := random(form1.clientHeight);
    doLine(i, data[i], clBlue)
  end;

  Items := form1.clientWidth - 2;

  distance := Items;
  repeat
    marker1 := 1;
    distance := trunc(distance / 2);
    marker2 := marker1 + distance;
    repeat
      if data[marker1] > data[marker2] then swap;
      marker1 := marker1 + 1;
      marker2 := marker2 + 1;
    until marker2 > Items;
  until distance = 1;
end;

end.
