{ Advanced\Search - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    Searching for text in a memo.

    Task.       Add text searching to the HotWeb example program.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Edit1: TEdit;
    ButtonSearch: TButton;
    Memo1: TMemo;
    Label1: TLabel;
    procedure ButtonSearchClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ -------------------------------------------------- }
{ NAME    - ButtonSearchClick                        }
{                                                    }
{ A procedure to search for text in a list box.      }
{                                                    }
{ INPUT   - Button Click triggers this procedure.    }
{           Edit1.Text is used by the procedure.     }
{           Text from the list box is used but not   }
{           altered.                                 }
{                                                    }
{ PROCESS - Search from middle to end and then from  }
{           start to middle.  This enables several   }
{           instances of an item to be located.      }
{                                                    }
{ OUTPUT  - If item is not found, this procedure     }
{           has no effect.  If an item is found, it  }
{           is selected in the list box              }
{ -------------------------------------------------- }
procedure TForm1.ButtonSearchClick(Sender: TObject);
var oldIndex, i : Integer;  { i is used to index items in the list box   }
                            { oldIndex is the initial list box itemindex }
    found       : Boolean;  { found is set to true if an item is found   }
begin
  found := False;           { no item has be found yet                   }

                            { Test to see if there are any items in list }
  if listBox1.Items.Count = 0 then
  begin                     { If there are no items, do not search       }
    messageDlg('There are no items.  Can not search.', mtError, [mbOK], 0)
  end
  else
  begin                     { Decide where to start searching from       }
    if listBox1.ItemIndex >= 0 then
    begin                   { Search from the middle of the list         }
      oldIndex := listBox1.ItemIndex;
    end
    else
    begin                   { Search from the head of the list           }
      oldIndex := -1;
    end;

                            { Search from the middle to the end of list  }
    i := oldIndex + 1;      { Start from the item after the current one  }
    while (i < listBox1.Items.Count) AND (not Found) do
    begin
      if pos(upperCase(edit1.Text), upperCase(listBox1.Items[i])) > 0 then
      begin
        found := True;      { This stops the search when item is found   }
        listBox1.ItemIndex := i     { Select the found item              }
      end;

      i := i + 1            { Next item in the list                      }
    end;
                            { Search from start to the middle of list    }
    i := 0;                 { First item in the list                     }
    while (i < oldIndex) AND (not Found) do
    begin
      if pos(upperCase(edit1.Text), upperCase(listBox1.Items[i])) > 0 then
      begin
        found := True;      { This stops the search when item is found   }
        listBox1.ItemIndex := i     { Select the found item              }
      end;

      i := i + 1            { Next item in the list                      }
    end
  end;

  edit1.setFocus;           { Make the edit control active               }
  edit1.selectAll           { Select all the text in the edit control    }
end;

end.
