{ Advanced\ScrnSave - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    A Screen Saver Template.
               Get your basic screen saver code working.
               View Project Source and add the $D SCRNSAVE line.
               Set Form1.KeyPreview to true.
               Compile the project.
               Copy the .EXE file to the Windows or Windows\System directory.
               Rename the .EXE file to .SCR.
               In Windows control panel desktop, select your new screen saver.

    TASK       Set up your own screen saver.
}

unit Ssave_f;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PanelNormal: TPanel;
    PanelSetup: TPanel;
    ButtonClose: TButton;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ButtonCloseClick(Sender: TObject);
    procedure PanelNormalMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    counter : Integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ A count down timer.  Used to prevent the saver closing immediately. }
procedure TForm1.FormCreate(Sender: TObject);
begin
  counter  := 5;
end;

{ Count down to zero.  Then stop counting down. }
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if counter > 0 then counter := counter - 1
end;

{ Close the setup panel. }
procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
  Close
end;

{ After the initial time delay, a mouse move will close the form. }
procedure TForm1.PanelNormalMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if counter = 0 then close
end;

{ After the initial time delay, a key down event will close the form. }
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if counter = 0 then close
end;

{ After the initial time delay, a key press event will close the form. }
procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if counter = 0 then close
end;

{ If the Setup button is pressed in the Windows Control Panel DeskTop,
  it will start this program with the /c parameter.  This procedure
  detects /c and shows the setup panel instead of the normal screen
  saver form.                                                          }
procedure TForm1.FormActivate(Sender: TObject);
begin
  { Is a previous instance of the screen saver running??? }
  if hPrevInst <> 0 then
  begin
    { Yes it is.  So close this instance. }
    close
  end;

  { Has a parameter been passed??? }
  if paramCount = 1 then
  begin
    { Yes it has.  Is it /c??? }
    if paramStr(1) = '/c' then
    begin
      { Yes it is. }
      panelNormal.hide;               { Hide the normal panel }
      panelSetup.show;                { Show the setup panel  }

      { Shrink the form. }
      Form1.Height := screen.Height div 2;
      Form1.Top    := screen.Height div 4;
      Form1.Width  := screen.Width div 2;
      Form1.Left   := screen.Width div 4
    end
  end
end;

end.

