{ Advanced\RClock\Complete - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    A clock program with a round face.

    Task.       Add the other clock hands.
}

unit Rclockf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    secAngle  : Integer;  { The angle of the second hand. }
    minAngle  : Integer;  { The angle of the minute hand. }
    hourangle : Integer;  { The angle of the hour hand. }

    size      : integer;  { Used to determing the size of the clock. }

    function getSize      : Integer;  { Radius of the clock face }
    function getSecAngle  : Integer;  { angle of the second hand }
    function getMinAngle  : Integer;  { angle of the minute hand }
    function getHourAngle : Integer;  { angle of the hour hand   }

    function angleToRadian(anAngle : Integer) : Real;  { a * 2 * Pi / 360 }

    procedure secHand;             { Draw the second hand  }
    procedure minHand;             { Draw the minute hand  }
    procedure hourHand;            { Draw the hour hand    }
    procedure drawFace;            { Draw the 12 dots      }
    procedure clearFace;           { Clear the whole image }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ ====================================================
  Input   : Angle in degrees
  Process : Convert input angle to radians
  Output  : Angle in radians is returned                }
function TForm1.angleToRadian(anAngle : Integer) : Real;
begin
  result := 2 * Pi * (anAngle mod 360) / 360
end;

{ ====================================================
  Input   : None
  Process : Convert a time in seconds to
            the angle of the minute hand
  Output  : The angle of the minute hand is returned.  }
function TForm1.getMinAngle : Integer;
begin
  { TASK - Write this code. }
end;

{ ====================================================
  Input   : None
  Process : Convert a time in seconds to
            the angle of the hour hand
  Output  : The angle of the hour hand is returned.  }
function TForm1.getHourAngle : Integer;
begin
  { TASK - Write this code. }
end;


{ ====================================================
  Input   : None
  Process : Convert a time in seconds to
            the angle of the second hand
  Output  : The angle of the second hand is returned.  }
function TForm1.getSecAngle : Integer;
begin
  result := 6 * strToInt(copy((timeToStr(time)), 7, 2))
end;

{ ====================================================
  Input   : None
  Process : Compare the client width and client height
            of the main form.  Set max to whichever
            value was the smaller.
  Output  : The value of max is returned.              }
function TForm1.getSize : Integer;
var max : Integer;
begin
  if Form1.ClientWidth > Form1.ClientHeight then
  begin
    max := form1.ClientHeight div 2
  end
  else
  begin
    max := form1.ClientWidth div 2
  end;

  result := max
end;

{ ====================================================
  Input   : None
  Process : Draw 12 small rectangles around the clock face.
            Draw a circle at the centre of the clock face
  Output  : Graphics are drawn.  }

procedure TForm1.DrawFace;
Var i, x, y : Integer;
    xx, yy  : Real;
Begin
  Canvas.Brush.Color := clBlack;
  Canvas.Pen.Color   := clBlack;

  for i := 0 to 11 do
  begin
    xx := (size - 2) * sin(angleToRadian(i * 30));
    yy := (size - 2) * cos(angleToRadian(i * 30));

    x := round(xx);
    y := round(yy);

    Canvas.rectangle(size + x - 2, size + y - 2,
                   size + x + 2, size + y + 2)
  end;

  Canvas.Ellipse(size - 5, size - 5, size + 5, size + 5)
end;

{ ====================================================
  Input   : None
  Process : Draw a gray rectangle to erase the whole clock face.
  Output  : Graphics are drawn.  }

procedure TForm1.ClearFace;
Begin
  Canvas.Brush.Color := clBtnFace;
  Canvas.Pen.Color   := clBtnFace;
  Canvas.Rectangle(0, 0, Form1.ClientWidth, Form1.ClientHeight);
end;

{ ====================================================
  Input   : None
  Process : Draw the second hand.
  Output  : Graphics are drawn.  }

procedure TForm1.secHand;
var xx, yy : real;
    x,  y  : Integer;
begin
  xx := (size - 10) * cos(angleToRadian(secAngle - 90));
  yy := (size - 10) * sin(angleToRadian(secAngle - 90));

  x := round(xx);
  y := round(yy);

  Canvas.Pen.Color   := clBlack;
  Canvas.Pen.Width   := 1;
  Canvas.MoveTo(size, size);
  Canvas.LineTo(size + x, size + y);
end;

{ ====================================================
  Input   : None
  Process : Draw the minute hand.
  Output  : Graphics are drawn.  }

procedure TForm1.minHand;
begin
  { TASK - Write this code. }
end;

{ ====================================================
  Input   : None
  Process : Draw the hour hand.
  Output  : Graphics are drawn.  }

procedure TForm1.hourHand;
begin
  { TASK - Write this code. }
end;

{ ====================================================
  Input   : None
  Process : On each clock tick (10 times per second)
            if the second hand has moved to a new angle then
            draw an ellipse to erase the previous clock hands.
            Store the angles of the second, minute and hour hands.
            Call the procedures to re-draw the clock hands.
            Call the procedure to re-draw the clock face.
  Output  : None or Graphics are drawn it the second hand has moved. }

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  { If secAngle has changed then re-draw the clock face. }
  if (secAngle  <> getSecAngle) then
  begin
    Canvas.Brush.Color := clBtnFace;
    Canvas.Pen.Color   := clBtnFace;
    Canvas.Ellipse(6, 6, 2 * Size - 6, 2 * Size  - 6);

    secAngle := getSecAngle;
    minAngle := getMinAngle;
    hourAngle := getHourAngle;

    secHand;
    minHand;
    hourHand;

    drawFace
  end
end;

{ ====================================================
  Input   : None
  Process : Initialise the clock face size.
            Clear the clock face.
  Output  : None.                                      }

procedure TForm1.FormCreate(Sender: TObject);
Begin
  size := getSize;
  clearFace
end;

{ ====================================================
  Input   : None
  Process : Initialise the clock face size.
            Clear the clock face.
  Output  : None.                                      }

procedure TForm1.FormResize(Sender: TObject);
Begin
  size := getSize;
  clearFace
end;

{ ==================================================== }

end.

{ ==================================================== }

