{ Advanced\Run_Time - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    Creation of controls at run time.  Any control can be
               created in this way.  Use this example as a template on
               which to base similar programs

    TASK       Create your own controls and make them visible.
               Do it without crashing the system!
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

{ ====================================================================== }

type
  TMyButton = class(TButton)    { My button is a TButton with added }
                                { behaviours.                       }

    { Added behaviour }
    Procedure Click; override;  { Handles the onClick event.        }
                                { Drop the 'on' and override the    }
                                { method.  Use on line help to find }
                                { out the procedure definition.     }
  End;

  TForm1 = class(TForm)         { The usual Delphi stuff            }
    ButtonCreate: TButton;
    ButtonFree: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ButtonCreateClick(Sender: TObject);
    procedure ButtonFreeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    pButton : TMyButton; { pButton points to a TMyButton }
                         { created at run time.          }
  end;

var
  Form1: TForm1;

{ ====================================================================== }

implementation

{$R *.DFM}

{ ====================================================================== }
{ Define how TMyButton behaves when clicked.                             }
Procedure TMyButton.Click;
Begin
  inherited Click;    { Don't forget this step or the button won't click }

  if form1.color = clBtnFace then    { Cycle through a few colours.      }
  begin
    form1.Color := clGreen
  end
  else if form1.color = clGreen then
  begin
    form1.Color := clBlue
  end
  else if form1.color = clBlue then
  begin
    form1.Color := clRed
  end
  else if form1.color = clRed then
  begin
    form1.Color := clBtnFace
  end
End;

{ ====================================================================== }
{ Initialise values when the program first starts up.                    }
procedure TForm1.FormCreate(Sender: TObject);
begin
  pButton := Nil;                   { This is important.                }
                                    { The program needs to know whether }
                                    { the button exists or not.         }
end;

{ ====================================================================== }
{ Clear up allocated memory before the program closes.  This is          }
{ important.  Failure to do this leads to memory leaks and Windows       }
{ crashes.                                                               }
procedure TForm1.FormDestroy(Sender: TObject);
begin
  if pButton <> Nil then             { if pButton needs clearing up      }
  begin
    form1.removeControl(pButton);
    pButton.Free;                    { Ensure the button is              }
                                     { freed on closedown                }
  end
end;

{ ====================================================================== }

procedure TForm1.ButtonCreateClick(Sender: TObject);
begin
  if pButton = Nil then    { OK to create ??? }
  begin
    pButton := TMyButton.Create(Form1);
    Form1.InsertControl(pButton);
    pButton.Caption := '&Red';
    pButton.Left := 100;
    pButton.Top := 100;
  end
end;

{ ====================================================================== }
{ If pButton points to a TMyButton created at run time then free it.     }
procedure TForm1.ButtonFreeClick(Sender: TObject);
begin
  if pButton <> Nil then          { Is there a button???                 }
  begin                           { Yes so clear it up.                  }
    Form1.RemoveControl(pButton); { Remove the control from Form1        }
    pButton.Free;                 { Free the memory used by the control. }
    pButton := Nil                { Do this so program knows pButton     }
                                  { points to nothing.                   }
  end
end;

end.

{ ====================================================================== }
