{ Advanced\Queue - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    This program demonstrates a queue.  The queue
               items are stored in a queue data structure, and
               also copied to a listBox to make them visible.

               Examples of queues.

               Printer queue.
               Disk access queue.
               Task queue - Windows programs waiting for a share of CPU time.

    TASK       Write programs to manage linked lists.  You should be
               able to write a FIFO queue, a LIFO stack and a program
               where you can insert and delete at any position in the
               list. 
}
unit Q_form;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TQueueNode = class(TObject)   { The queue is made by creating and }
    item : String;              { linking these objects             }
    next : TQueueNode;
  end;

  TFormQueue = class(TForm)
    ListBoxQueue: TListBox;
    EditQItem: TEdit;
    ButtonAdd: TButton;
    ButtonRemove: TButton;
    LabelEdit: TLabel;
    Label1: TLabel;
    LabelHead: TLabel;
    LabelTail: TLabel;
    procedure ButtonAddClick(Sender: TObject);
    procedure ButtonRemoveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    head      : TQueueNode;
    tail      : TQueueNode;

    procedure addToQueue(anItem : String);
    procedure removeFromQueue;

    procedure updateDisplays;
  end;

var
  FormQueue: TFormQueue;

implementation

{$R *.DFM}
{ ------------------------------------------------------------------- }
{
    Every time the queue is altered, this procedure is called to
    update the screen displays to provide feedback to the user.
}
procedure TFormQueue.updateDisplays;
Var pScan : TQueueNode;
begin
  { SET THE HEAD LABEL }
  if head <> Nil then
  begin
    LabelHead.Caption := 'Head = ' + head.item
  end
  else
  begin
    LabelHead.Caption := 'Head = Nil'
  end;

  { SET THE TAIL LABEL }
  if tail <> Nil then
  begin
    LabelTail.Caption := 'Tail = ' + tail.item
  end
  else
  begin
    LabelTail.Caption := 'Tail = Nil'
  end;

  { COPY THE QUEUE TO A LIST BOX TO MAKE IT VISIBLE }
  listBoxQueue.Clear;          { Clear the list box }
  pScan := head;               { Scan from the head }
  while pScan <> Nil do        { Detect queue end   }
  begin
    listBoxQueue.Items.Add(pScan.item);  { Add queue item to listBox  }
    pScan := pScan.next                  { scan next item in the list }
  end
end;

{ ------------------------------------------------------------------- }
{   Input    : Procedure is called when the remove button is clicked.

    Proocess : If the queue is empty then display a warning message.
               If the queue has a single item, delete it and set the
               head and tail pointers to NIL.
               If the queue has more than one item then delete the
               head item.

    Output   : Queue with the head removed or an empty queue.         }

procedure TFormQueue.removeFromQueue;
Var pDel : TQueueNode;
begin
  pDel := head;

  if head = Nil  then                { EMPTY LIST }
  begin
    messageDlg('Queue is empty.', mtInformation, [mbOK], 0)
  end
  else if head.Next = Nil then       { SINGLE ITEM ON LIST }
  begin
    head := Nil;
    tail := Nil;
    pDel.Free
  end
  else                               { TWO OR MORE ITEMS ON LIST }
  begin
    head := head.next;
    pDel.Free
  end
end;

{ ------------------------------------------------------------------- }
{   Input   : Procedure is called when the Add button is pressed.

    Process : If the queue is empty then create a queue item and
              set the head and tail pointers to point to it.

              Otherwise add an item to the tail of the queue.

    Output  : Queue with a single item or an item added to the tail.  }

procedure TFormQueue.addToQueue(anItem : String);
begin
  if head = Nil then
  begin
    tail := TQueueNode.Create; { Create a node and make tail point at it }
    tail.next := Nil;          { Label the end of the queue              }
    tail.item := anItem;       { Store the data into the node            }
    head := tail               { Only one item so head also points at it }
  end
  else
  begin
    tail.next := TQueueNode.Create; { tail.next points at created node   }
    tail := tail.next;              { tail points to the new tail        }
    tail.next := Nil;               { Label the end of the queue         }
    tail.item := anItem             { Store the data into the node       }
  end;
end;

{ ------------------------------------------------------------------- }

procedure TFormQueue.ButtonAddClick(Sender: TObject);
begin
  if EditQItem.Text = '' then
  begin
    messageDlg('Type in a name first.', mtInformation, [mbOK], 0)
  end
  else
  begin
    addToQueue(EditQItem.Text);
    EditQItem.setFocus;
    EditQItem.selectAll;
    updateDisplays
  end
end;

{ ------------------------------------------------------------------- }

procedure TFormQueue.ButtonRemoveClick(Sender: TObject);
begin
  removeFromQueue;
  updateDisplays
end;

{ ------------------------------------------------------------------- }

procedure TFormQueue.FormCreate(Sender: TObject);
begin
  head := Nil;
  tail := Nil;
  updateDisplays
end;

{ ------------------------------------------------------------------- }

procedure TFormQueue.FormDestroy(Sender: TObject);
Var pDel : TQueueNode;
begin
  while head <> Nil do                   { Free all the QueueNodes.   }
  begin                                  { If you forget to do this,  }
    pDel := head;                        { Windows will gradually run }
    head := head.next;                   { out of memory if you run   }
    pDel.free;                           { the program repeatedly!    }
  end
end;

end.

{ ------------------------------------------------------------------- }

