{ Advanced\PChar - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    Converting a string to a PChar null terminated string.

    Task.       Use this technique to launch an application using
                shellExecute which requires PChar parameters.  Specify
                an application like NOTEPAD.EXE using an edit control
                for input.
}

unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Image1: TImage;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ This procedure converts a string to a PChar.
  PChar is also known as ASCIIZ or NULL terminated or C String. }
procedure TForm1.Button1Click(Sender: TObject);
Var p : PChar;                        { p will point to a null
                                        terminated string               }

    s : string;                       { s will hold a normal string     }
    o : string;                       { o will hold a normal string     }
begin
  canvas.textOut(10, 10, 'Copy edit1.text to s.');
  s := edit1.text;                    { Normal delphi string copying    }

  canvas.textOut(10, 30, 'Allocate heap memory to store s as a PChar.');
  p := strAlloc(length(s) + 1);       { Make p point to a chunk of
                                        memory big enough to hold
                                        s and the null character        }

  canvas.textOut(10, 50, 'Copy s to the allocated heap memory.');
  p := StrPCopy(p, s);                { This copies s to p and converts
                                        from string to PChar format     }

  canvas.textOut(10, 70, 'Copy heap memory to o.');
  o := strPas(p);                     { This copies p to o converting
                                        back to a pascal string         }

  canvas.textOut(10, 90, 'Display o in the label to see if the conversions worked.');
  label1.caption := o;                { See if o is correct             }

  canvas.textOut(10, 110, 'Free the memory allocated earlier.');
  strDispose(p);                      { Free the memory you allocated
                                        earlier.  If you forget, your
                                        system will eventually run
                                        out of memory and crash         }
end;

end.
