{ Advanced\Passwd - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    Password protect your computer.

    Task.       Convert it to work on any screen resolution.
                Use the form activate procedure to re-size
                and re-position screen controls correctly.
}

unit Passform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TformPass = class(TForm)
    timerPasswd: TTimer;
    Panel1: TPanel;
    labelLock: TLabel;
    editPasswd: TEdit;
    buttonLock: TButton;
    LabelInstr: TLabel;
    Panel2: TPanel;
    Image1: TImage;
    Panel3: TPanel;
    labelTime: TLabel;
    procedure buttonLockClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure timerPasswdTimer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    passWord : String;
    passWdOK : Boolean;
    aTime    : TDateTime;
    now      : TDateTime;
    oldNow   : TDateTime;
    { Public declarations }
  end;

var
  formPass: TformPass;

implementation

{$R *.DFM}

procedure TformPass.buttonLockClick(Sender: TObject);
begin
  if (length(editPasswd.Text) > 0) AND (buttonLock.Caption = 'Lock') then
  begin
    passWord := editPasswd.Text;
    buttonLock.Caption := 'Unlock';
    labelLock.Caption := 'Retype the same password.';
    caption := 'Unlock Your Computer';
    editPasswd.Text := ''
  end
  else if length(editPasswd.Text) <> 0 then
  begin
    if editPasswd.Text = passWord then
    begin
      passWdOK := True;
      close
    end
    else
    begin
      editPasswd.Text := '';
      messageBeep(0)
    end
  end
  else
  begin
    messageBeep(0)
  end;

  editPasswd.SetFocus
end;

procedure TformPass.FormCreate(Sender: TObject);
begin
  editPasswd.Text := '';
  passWord := '';
  passWdOK := False;
  aTime := time;
end;

procedure TformPass.timerPasswdTimer(Sender: TObject);
begin
  if top  <> 0 then top  := 0;
  if left <> 0 then left := 0;
  show;
  now := time;
  if (now - aTime) <> oldNow then
    labelTime.Caption := 'Time elapsed = ' + TimeToStr(now - aTime);

  oldNow := now - aTime
end;

procedure TformPass.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if passWdOK then
    canClose := true
  else
    canClose := false
end;

end.
