{ Advanced\Mandle - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    The classic Mandlebrot set.

    TASK       Experiment with the starting conditions.
}

unit Mandelf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

const
  iters  = 35;
  scale  = 1.0;   { Scale 1 is full screen.   4 is small.}
  xRange = -2.5;
  yRange = -1.5;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var i, j, k, it : Integer;
    cr, ci, zr, zi, zm, z1, z2, zr2, zi2 : Real;
    red, grn, blu : TColor;
    a : array[0.. 4] of Integer;
    b : array[0.. 4] of Integer;
    c : array[0..34] of TColor;
begin
  a[0] := 0;  a[1] := 1;  a[2] := 0;  a[3] := 1;
  b[0] := 0;  b[1] := 1;  b[2] := 1;  b[3] := 0;

  c[0] := clBlack;
  c[1] := clMaroon;
  c[2] := clGreen;
  c[3] := clOlive;
  c[4] := clNavy;
  c[5] := clPurple;
  c[6] := clTeal;
  c[7] := clGray;
  c[8] := clSilver;
  c[9] := clRed;
  c[10] := clLime;
  c[11] := clBlue;
  c[12] := clFuchsia;
  c[13] := clAqua;
  c[14] := clWhite;
  c[15] := clBackground;
  c[16] := clActiveCaption;
  c[17] := clInactiveCaption;
  c[18] := clMenu;
  c[19] := clWindow;
  c[20] := clWindowFrame;
  c[21] := clMenuText;
  c[22] := clWindowText;
  c[23] := clCaptionText;
  c[24] := clActiveBorder;
  c[25] := clInactiveBorder;
  c[26] := clAppWorkSpace;
  c[27] := clHighlight;
  c[28] := clHighlightText;
  c[29] := clBtnFace;
  c[30] := clBtnShadow;
  c[31] := clGrayText;
  c[32] := clBtnText;
  c[33] := clInactiveCaptionText;
  c[34] := clBtnHighlight;

  for i := 0 to 3 do
  begin
    j := a[i];
    while j <= round(clientHeight / scale) do
    begin
      k := b[i];
      while k <= round(clientWidth / scale) do
      begin
        cr := xRange + k * 4 / (clientWidth / scale);
        ci := yRange + j * 3 / (clientHeight / scale);
        zm := 0;  zr := 0;  zi := 0;  zr2 := 0;  zi2 := 0;

        it := -1;
        while (it < iters) AND (zm < 4) do
        begin
          z1 := zr2 - zi2 + cr;
          z2 := 2 * zr * zi + ci;
          zr := z1;
          zi := z2;
          zr2 := zr * zr;
          zi2 := zi * zi;
          zm := zr2 + zi2;

          it := it + 1
        end;

        red := it;
        grn := $100 - it;
        blu := it;

        canvas.pixels[k, j] := c[it];

        k := k + 2
      end;

      j := j + 2
    end
  end
end;

end.
