{ Advanced\Life2 - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    Game of life using graphics.

    TASK       Research Artificial Life.  Create your own creatures.
}

unit Life;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, StdCtrls, ExtCtrls;

const
  rowCount = 30;
  colCount = 30;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ButtonClear: TButton;
    ButtonNextGen: TButton;
    Image1: TImage;
    Image2: TImage;
    Timer1: TTimer;
    procedure ButtonNextGenClick(Sender: TObject);
    procedure ButtonClearClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    sg : array[0..colCount - 1, 0..rowCount - 1] of Char;
    thePiccy : TGraphic;
    blankPic : TGraphic;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ButtonNextGenClick(Sender: TObject);
Var row, col, count : Integer;
begin
  { Repeat for all the columns but not the edges. }
  For col := 1 to colCount - 2 do
  Begin
    { For each column repeat for all the rows but not the edges. }
    For row := 1 to rowCount - 2 do
    Begin
      count := 0;   { Start counting creatures from zero. }

      { XOO }
      { OOO }
      { OOO }
      if (sg[col - 1, row - 1] = 'a') OR
         (sg[col - 1, row - 1] = 'd') then count := Count + 1;

      { OOO }
      { XOO }
      { OOO }
      if (sg[col - 1, row - 0] = 'a') OR
         (sg[col - 1, row - 0] = 'd') then count := Count + 1;

      { OOO }
      { OOO }
      { XOO }
      if (sg[col - 1, row + 1] = 'a') OR
         (sg[col - 1, row + 1] = 'd') then count := Count + 1;

      { OXO }
      { OOO }
      { OOO }
      if (sg[col - 0, row - 1] = 'a') OR
         (sg[col - 0, row - 1] = 'd') then count := Count + 1;

      { OOO }
      { OXO }
      { OOO }
      if (sg[col - 0, row - 0] = 'a') OR
         (sg[col - 0, row - 0] = 'd') then count := Count + 1;

      { OOO }
      { OOO }
      { OXO }
      if (sg[col - 0, row + 1] = 'a') OR
         (sg[col - 0, row + 1] = 'd') then count := Count + 1;

      { OOX }
      { OOO }
      { OOO }
      if (sg[col + 1, row - 1] = 'a') OR
         (sg[col + 1, row - 1] = 'd') then count := Count + 1;

      { OOO }
      { OOX }
      { OOO }
      if (sg[col + 1, row - 0] = 'a') OR
         (sg[col + 1, row - 0] = 'd') then count := Count + 1;

      { OOO }
      { OOO }
      { OOX }
      if (sg[col + 1, row + 1] = 'a') OR
         (sg[col + 1, row + 1] = 'd') then count := Count + 1;

      { == Counting Finished.  Now make the life and death decisions == }

      { If lonely then die.  Two or fewer neighbours. }
      { If the cell is alive AND three or fewer creatures including self. }
      if (sg[col, row] = 'a') AND (count < 3) then
      begin
        sg[col, row] := 'd';   { d for dying }
      end;

      { If crowded then die.  Four or more neighbours. }
      { If the cell is alive AND five or more creatures including self. }
      if (sg[col, row] = 'a') AND (count >= 5) then
      begin
        sg[col, row] := 'd';   { d for dying }
      end;

      { If just right then breed.  Three creatures needed. }
      { If the cell is empty and there are three surrounding creatures. }
      if (sg[col, row] = ' ') AND (count = 3) then
      begin
        sg[col, row] := 'c';   { c for conveived. }
      end;
    End
  End;

  { == Finished counting, conceiving and dying ======================== }

  { == Now clear up the dying creatures.  Make conceived ones alive. == }

  { Repeat for all the columns but not the edges. }
  For col := 1 to colCount - 2 do
  Begin
    { For each column repeat for all the rows but not the edges. }
    For row := 1 to rowCount - 2 do
    Begin
      if sg[col, row] = 'c' then
      begin
        sg[col, row] := 'a';
{       canvas.pen.color := clRed;
        canvas.brush.color := clRed;
        canvas.rectangle(col * 10, row * 10, col * 10 + 10, row * 10 + 10); }
        canvas.draw(col * 10, row * 10, thePiccy)
      end;

      if sg[col, row] = 'd' then
      begin
        sg[col, row] := ' ';

{       canvas.pen.color := clBtnFace;
        canvas.brush.color := clBtnFace;
        canvas.rectangle(col * 10, row * 10, col * 10 + 10, row * 10 + 10);  }
        canvas.draw(col * 10, row * 10, blankPic)
      end
    End
  End
end;

procedure TForm1.ButtonClearClick(Sender: TObject);
Var row, col : Integer;
begin
  { Repeat for all the columns }
  For col := 0 to colCount - 1 do
  Begin
    { For each column repeat for all the rows }
    For row := 0 to rowCount - 1 do
    Begin
      { Set the cell to the Empty String. }
      sg[col, row] := ' ';

{     canvas.pen.color := clBtnFace;
      canvas.brush.color := clBtnFace;
      canvas.rectangle(col * 10, row * 10, col * 10 + 10, row * 10 + 10);  }
      canvas.draw(col * 10, row * 10, blankPic)
    End
  End
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ButtonClearClick(Nil);

  thePiccy := image1.picture.graphic;
  blankPic := image2.picture.graphic;
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
Var xx, yy : Integer;
begin
  xx := x - x mod 10;
  yy := y - y mod 10;

  if button = mbLeft then
  begin
    if (xx < 300) AND (yy < 300) then
    begin
      sg[xx div 10, yy div 10] := 'a';

{     canvas.pen.Color := clRed;
      canvas.brush.Color := clRed;
      canvas.rectangle(xx, yy, xx + 10, yy + 10);  }
      canvas.draw(xx, yy, thePiccy);
    end
  end
  else
  begin
    if (xx < 300) AND (yy < 300) then
    begin
      sg[xx div 10, yy div 10] := ' ';

{     canvas.pen.Color := clBtnFace;
      canvas.brush.Color := clBtnFace;
      canvas.rectangle(xx, yy, xx + 10, yy + 10)  }
      canvas.draw(xx, yy, blankPic)
    end
  end
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  ButtonNextGenClick(Nil);
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
Var xx, yy : Integer;
begin
  xx := x - x mod 10;
  yy := y - y mod 10;

  if (xx < 300) AND (yy < 300) then
  begin
    sg[xx div 10, yy div 10] := 'a';

{     canvas.pen.Color := clRed;
    canvas.brush.Color := clRed;
    canvas.rectangle(xx, yy, xx + 10, yy + 10);  }
    canvas.draw(xx, yy, thePiccy);
  end
end;

end.
