{ Advanced\Life - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    The game of life.  Create a seed population and press
                Next Gen to see how it evolves.  Here are some examples of
                seed populations.  Use the letter 'a' to represent an alive
                creature.

                a a a          a
                a a a            a
                a a a        a a a

    Task.       Write your own version of this program using a two
                dimensional array instead of a string grid.  Set live
                creatures by left mouse clicking on the screen.  Clear
                live creatures by right clicking them.  Use canvas
                painting procedures to make the creatures visible.
                If you get this right, your program will run very much
                faster than the string grid example above.
}

unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, StdCtrls, ExtCtrls;

type
  TFormMain = class(TForm)
    Panel1: TPanel;
    ButtonNextGen: TButton;
    ButtonClear: TButton;
    StringGridLife: TStringGrid;
    procedure ButtonNextGenClick(Sender: TObject);
    procedure ButtonClearClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

procedure TFormMain.ButtonNextGenClick(Sender: TObject);
var count    : Integer;
    row, col : Integer;
begin
  for col := 1 to stringGridLife.colCount - 2 do
  begin
    for row := 1 to stringGridLife.rowCount - 2 do
    begin
      count := 0;

      if (stringGridLife.cells[col - 1, row - 1] = 'a') OR    { alive }
         (stringGridLife.cells[col - 1, row - 1] = 'd') then  { dying }
        count := count + 1;

      if (stringGridLife.cells[col - 0, row - 1] = 'a') OR    { alive }
         (stringGridLife.cells[col - 0, row - 1] = 'd') then  { dying }
        count := count + 1;

      if (stringGridLife.cells[col + 1, row - 1] = 'a') OR    { alive }
         (stringGridLife.cells[col + 1, row - 1] = 'd') then  { dying }
        count := count + 1;

      if (stringGridLife.cells[col - 1, row - 0] = 'a') OR    { alive }
         (stringGridLife.cells[col - 1, row - 0] = 'd') then  { dying }
        count := count + 1;

      if (stringGridLife.cells[col - 0, row - 0] = 'a') OR    { alive }
         (stringGridLife.cells[col - 0, row - 0] = 'd') then  { dying }
        count := count + 1;

      if (stringGridLife.cells[col + 1, row - 0] = 'a') OR    { alive }
         (stringGridLife.cells[col + 1, row - 0] = 'd') then  { dying }
        count := count + 1;

      if (stringGridLife.cells[col - 1, row + 1] = 'a') OR    { alive }
         (stringGridLife.cells[col - 1, row + 1] = 'd') then  { dying }
        count := count + 1;

      if (stringGridLife.cells[col - 0, row + 1] = 'a') OR    { alive }
         (stringGridLife.cells[col - 0, row + 1] = 'd') then  { dying }
        count := count + 1;

      if (stringGridLife.cells[col + 1, row + 1] = 'a') OR    { alive }
         (stringGridLife.cells[col + 1, row + 1] = 'd') then  { dying }
        count := count + 1;

      if (stringGridLife.cells[col, row] = 'a') AND (count < 3) then
      begin
        stringGridLife.cells[col, row] := 'd'    { die of lonelyness }
      end;

      if (stringGridLife.cells[col, row] = 'a') AND (count > 4) then
      begin
        stringGridLife.cells[col, row] := 'd'    { die of over-crowding }
      end;

      if (stringGridLife.cells[col, row] = '') AND
         (count = 3) then
      begin
        stringGridLife.cells[col, row] := 'c'    { new creature conceived }
      end
    end
  end;

  for col := 0 to stringGridLife.colCount - 1 do
  begin
    for row := 0 to stringGridLife.rowCount - 1 do
    begin
      if stringGridLife.cells[col, row] = 'c' then
        stringGridLife.cells[col, row] := 'a';

      if stringGridLife.cells[col, row] = 'd' then
        stringGridLife.cells[col, row] := '';
    end
  end
end;

procedure TFormMain.ButtonClearClick(Sender: TObject);
var count    : Integer;
    row, col : Integer;
begin
  for col := 0 to stringGridLife.colCount - 1 do
  begin
    for row := 0 to stringGridLife.rowCount - 1 do
    begin
      stringGridLife.cells[col, row] := ''
    end
  end
end;

end.
