{ Advanced\IconExtr - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    Extracts icons from an exe file.
               Fails if there is no icon in the file!

    TASK       Use this technique if you need it.
}

unit Ico;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, shellapi, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ButtonBrowse: TButton;
    Panel1: TPanel;
    Buttonsave: TButton;
    Image1: TImage;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    procedure ButtonBrowseClick(Sender: TObject);
    procedure ButtonsaveClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ButtonBrowseClick(Sender: TObject);
var ExeFileName : PChar;
    Icon        : HIcon;
    IconCount   : Integer;
begin
  if openDialog1.execute then
  begin
    ExeFileName := stralloc(length(openDialog1.FileName));
    ExeFileName := strPcopy(ExeFileName, openDialog1.FileName);

    { Extracts the first icon out of the named EXE file. }
    Icon := ExtractIcon(Handle, ExeFileName, strToInt(edit1.Text));

    { Finds out how many icons there were.  $FFFF equivalent to -1 }
    IconCount := ExtractIcon(Handle, ExeFileName, $FFFF);

    label1.Caption := intToStr(IconCount) + ' icons found.';
    image1.picture.icon.handle := icon;
  end
end;

procedure TForm1.ButtonsaveClick(Sender: TObject);
begin
  if savedialog1.execute then
  begin
    image1.picture.savetofile(savedialog1.filename)
  end
end;

end.

