{ Advanced\Hotweb - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    An editor similar to Windows Notepad.  This editor
                allows you to add HTML tags to plain text.

    task.       Add some tags of your own.  Test the results using
                a Web Browser.
}

unit Mainform;

interface

uses Forms, StdCtrls, ExtCtrls, Dialogs, Menus, Classes,
     Controls, SysUtils, Graphics;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Memo1: TMemo;
    ButtonHTML: TButton;
    ButtonH1: TButton;
    ButtonH2: TButton;
    ButtonH3: TButton;
    ButtonBR: TButton;
    ButtonHR: TButton;
    ButtonP: TButton;
    MainMenu1: TMainMenu;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    ButtonLink: TButton;
    ButtonBrowse: TButton;
    Timer1: TTimer;
    ButtonImg: TButton;
    ButtonUL: TButton;
    ButtonPre: TButton;
    ButtonBold: TButton;
    New1: TMenuItem;
    procedure ButtonHTMLClick(Sender: TObject);
    procedure ButtonH1Click(Sender: TObject);
    procedure ButtonH2Click(Sender: TObject);
    procedure ButtonH3Click(Sender: TObject);
    procedure ButtonBRClick(Sender: TObject);
    procedure ButtonHRClick(Sender: TObject);
    procedure ButtonPClick(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure ButtonLinkClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure ButtonBrowseClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ButtonImgClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ButtonULClick(Sender: TObject);
    procedure ButtonPreClick(Sender: TObject);
    procedure ButtonBoldClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure New1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    loaded : boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ButtonHTMLClick(Sender: TObject);
begin
  if memo1.lines.count = 0 then
  begin
    memo1.lines.add('<HTML>');
    memo1.lines.add('');
    memo1.lines.add('<HEAD>');
    memo1.lines.add('<TITLE>');
    memo1.lines.add('');
    memo1.lines.add('</TITLE>');
    memo1.lines.add('</HEAD>');
    memo1.lines.add('');
    memo1.lines.add('<BODY BGCOLOR="#DDEEFF">');
    memo1.lines.add('');
    memo1.lines.add('</BODY>');
    memo1.lines.add('');
    memo1.lines.add('</HTML>');
  end;
  memo1.setFocus
end;

procedure TForm1.ButtonH1Click(Sender: TObject);
begin
  memo1.seltext := '<H1>' + memo1.seltext + '</H1>';
  memo1.selstart := memo1.selstart - 5;
  memo1.setFocus
end;

procedure TForm1.ButtonH2Click(Sender: TObject);
begin
  memo1.seltext := '<H2>' + memo1.seltext + '</H2>';
  memo1.selstart := memo1.selstart - 5;
  memo1.setFocus
end;

procedure TForm1.ButtonH3Click(Sender: TObject);
begin
  memo1.seltext := '<H3>' + memo1.seltext + '</H3>';
  memo1.selstart := memo1.selstart - 5;
  memo1.setFocus
end;

procedure TForm1.ButtonBRClick(Sender: TObject);
begin
  memo1.seltext := '<BR>';
  memo1.setFocus
end;

procedure TForm1.ButtonHRClick(Sender: TObject);
begin
  memo1.seltext := '<HR>';
  memo1.setFocus
end;

procedure TForm1.ButtonPClick(Sender: TObject);
begin
  memo1.seltext := '<P>';
  memo1.setFocus
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  if openDialog1.execute then
  begin
    if memo1.modified then Save1Click(Nil);
    memo1.lines.loadFromFile(openDialog1.filename);
    saveDialog1.fileName := openDialog1.filename;
    caption := openDialog1.filename
  end
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  if saveDialog1.fileName <> '' then
  begin
    memo1.lines.saveToFile(saveDialog1.fileName);
    memo1.modified := False
  end
  else
  begin
    SaveAs1Click(Nil);
  end
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
  if saveDialog1.execute then
  begin
    memo1.lines.saveToFile(saveDialog1.fileName);
    memo1.modified := False;
    caption := saveDialog1.fileName;
  end
end;

procedure TForm1.ButtonLinkClick(Sender: TObject);
Var s : String;
begin
  s := memo1.Seltext;
  memo1.clearSelection;
  memo1.seltext := '<A HREF="">' + memo1.seltext + '</A>';
  memo1.selstart := memo1.selstart - 6;
  ButtonBrowseClick(Nil);
  memo1.selstart := memo1.selstart + 2;
  memo1.seltext := s;
  memo1.setFocus
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  close
end;

procedure TForm1.ButtonBrowseClick(Sender: TObject);
begin
  if openDialog1.execute then
  begin
    memo1.seltext := lowerCase(extractFileName(openDialog1.fileName));
    memo1.setFocus
  end
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if memo1.modified then             { TColor }
    panel1.color := clRed
  else
    panel1.color := clBtnFace
end;

procedure TForm1.ButtonImgClick(Sender: TObject);
begin
  memo1.seltext := '<IMG SRC="">';
  memo1.selstart := memo1.selstart - 2;
  ButtonBrowseClick(Nil);
  memo1.selstart := memo1.selstart + 2;
  memo1.setFocus
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  memo1.setFocus;
  if (not loaded) AND (paramcount > 0) then
  begin
    if fileExists(paramStr(1)) then
    begin
      memo1.lines.loadFromFile(paramStr(1));
      caption := paramStr(1);
      saveDialog1.fileName := paramStr(1);
      loaded := true
    end
  end
end;

procedure TForm1.ButtonULClick(Sender: TObject);
begin
  memo1.seltext := '<UL>' + memo1.seltext + '</UL>';
  memo1.setFocus
end;

procedure TForm1.ButtonPreClick(Sender: TObject);
begin
  memo1.seltext := '<PRE>' + memo1.seltext + '</PRE>';
  memo1.setFocus
end;

procedure TForm1.ButtonBoldClick(Sender: TObject);
begin
  memo1.seltext := '<B>' + memo1.seltext + '</B>';
  memo1.selstart := memo1.selstart - 4;
  memo1.setFocus
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  loaded := false
end;

procedure TForm1.New1Click(Sender: TObject);
begin
  Save1Click(Nil);
  memo1.clear;
  saveDialog1.fileName := '';
  openDialog1.fileName := '';
  caption := ''
end;

end.
