{ Advanced\HelpHelp - Example program from http://www.SoftwareForEducation.com/ }

{
    Example.    This program has an on-line context sensitive help system.
                Look at the RTF and HLP files.  These give many clues on
                the creation of on-line help.

    Task 1.     Convert one of your more interesting programs to have
                on-line help.

    Task 2.     Once you have learned how to do this, you can add help
                systems to any program, spreadsheets and databases.

    Task 3.     Write a stand-alone help file on a topic of your choice.

    Task 4.     Find out about the new HTML Help Workshop.
}

unit Helpf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    ButtonRectangle: TButton;
    ButtonEllipse: TButton;
    ButtonHelp: TButton;
    procedure ButtonRectangleClick(Sender: TObject);
    procedure ButtonEllipseClick(Sender: TObject);
    procedure ButtonHelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ButtonRectangleClick(Sender: TObject);
begin
  canvas.pen.color   := 0;  { clBlack = 0 }

  canvas.brush.color := random($FF) +        { Red   }
                        100 * random($FF) +  { Green }
                        10000 * random($FF); { Blue  }

  canvas.rectangle(100, 32, 189, 65)
end;

procedure TForm1.ButtonEllipseClick(Sender: TObject);
begin
  canvas.pen.color   := 0;  { clBlack = 0 }

  canvas.brush.color := random($FF) +        { Red   }
                        100 * random($FF) +  { Green }
                        10000 * random($FF); { Blue  }

  canvas.ellipse(100, 72, 189, 105)
end;

procedure TForm1.ButtonHelpClick(Sender: TObject);
begin
  application.helpJump('Contents001')
end;

{ This procedure runs once when the application starts up. }
procedure TForm1.FormCreate(Sender: TObject);
begin
  { Ensure the application looks for its help file in the correct place. }
  application.helpFile := extractFilePath(application.exeName) + 'Helpp.Hlp'
end;

end.
