{ Advanced\HashTab - Example program from http://www.SoftwareForEducation.com/ }

{
    EXAMPLE    A Hash Table Program.

               Hash tables are usually much bigger than this.

               The chief advantage of a hash table is SPEED of insertion
               and location of objects in the table.

               The main disadvantage of hash tables is that they can not be
               sorted into alphabetical or any other useful order.

    TASK       Research and implement other hashing algorithms.  Identify
               examples of hashing algorithms that would cause serious
               efficiency problems.
}
unit Hashform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

Const
  TABLESIZE = 10;  { Normally a much larger table would be used. }

type
  { HashNodes are stored in the hash table. }
  { A single linked list of hash nodes will }
  { grow if there are insertion collisions. }
  HashNode = Class(TObject)
    item : string;
    next : HashNode;
  end;

  TFormHash = class(TForm)
    Panel1: TPanel;
    Edit1: TEdit;
    ButtonInsert: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure ButtonInsertClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    { This is the hash table. }
    table : array[0..TABLESIZE - 1] of HashNode;
  end;

var
  FormHash: TFormHash;

implementation

{$R *.DFM}

{ Procedure runs once when the form is created. }
{ Main form caption is set.                     }
{ Hash table is initialised empty.              }
procedure TFormHash.FormCreate(Sender: TObject);
var i : integer;
begin
  caption := 'Hash Table Example - Table Size = ' + intToStr(TABLESIZE);

  { Label with Nil to indicate table is empty. }
  for i := 0 to TABLESIZE - 1 do
  begin
    table[i] := Nil
  end;
end;

{ Procedure runs when the Insert button is clicked.    }
{ Nested functions and procedures do most of the work. }
procedure TFormHash.ButtonInsertClick(Sender: TObject);

        { A function to calculate the hash total. }
        { This is the sum of the ASCII codes.     }
        function getHashTotal(s : string) : Integer;
        var i, total : integer;
        begin
          total := 0;

          for i := 1 to length(s) do
          begin
            total := total + ord(s[i])
          end;

          getHashTotal := total
        end;

        { A function to return the hash code. }
        function getHashCode(aHashTotal : integer) : Integer;
        begin
          getHashCode := aHashTotal mod TABLESIZE
        end;

        { A procedure to add an item to the hash table at the coded position. }
        procedure hashAdd(anItem : string; aHashCode : integer);
        var newNode, scan : HashNode;
            isDuplicate   : Boolean;
        begin
          { scan is used to search for a duplicate entry }
          scan := table[aHashCode];

          { assume there are no duplicates to start with }
          isDuplicate := false;

          { scan the list for duplicates }
          while scan <> nil do
          begin
            { if the items match there is a duplicate }
            if scan.item = anItem then
            begin
              { yes there was a duplicate }
              isDuplicate := True;

              { no need to scan the rest of the list }
              break
            end;

            scan := scan.next
          end;

          { insert the item if there was no duplicate }
          { item is added to the head of the list     }
          { table[aHashCode] points to the head       }
          if not isDuplicate then
          begin
            { create the new node }
            newNode := hashNode.create;

            { store the item }
            newNode.Item := anItem;

            { set the next pointer }
            newNode.next := table[aHashCode];

            { add item to the list }
            table[aHashCode] := newNode;
          end
        end;

        { A procedure to scan the hash table and make it }
        { visible by adding items to a memo. }
        procedure hashDisplay;
        var scan : hashNode;
            i    : integer;
        begin
          { Clear the previous display. }
          memo1.clear;

          { Scan the table }
          for i := 0 to TABLESIZE - 1 do
          begin
            { Insert a title }
            memo1.lines.add('Table position ' + intTOStr(i));

            { Scan the list at the current table position }
            scan := table[i];
            while scan <> Nil do
            begin
              { Add the current item to the memo }
              memo1.lines.add('    ' + scan.item);
              scan := scan.next
            end;

            { A blank separator line. }
            memo1.lines.add('');
          end
        end;

{ Here is the main procedure                                }
{ Most of the work is done by the nested procedures, above. }
var hashCode, hashTotal : Integer;
begin
  { Can not insert a blank item. }
  if edit1.text = '' then
  begin
    messageDlg('Can not insert blank text.', mtError, [mbOK], 0)
  end
  else
  begin
    { Calculate and display the hash total. }
    hashTotal := getHashTotal(edit1.text);
    label1.caption := 'Hash Total = ' + intToStr(hashTotal);

    { Calculate and display the hash code. }
    hashCode  := getHashCode(hashTotal);
    label2.caption := 'Hash Code  = ' + intToStr(hashCode);

    { Add the item to the hash table }
    hashAdd(edit1.Text, hashCode);

    { re-display the hash table contents }
    hashDisplay;
  end;

  edit1.setFocus;
  edit1.selectAll
end;

{
  Procedure runs once when program closes.
  Visit every table position.
  Free all items at that position.
  This is important to avoid memory leak problems.
}
procedure TFormHash.FormDestroy(Sender: TObject);
var i    : integer;
    pDel : HashNode;
begin
  { Scan the hash table }
  for i := 0 to TABLESIZE - 1 do
  begin
    { Scan the list of entries at the current table position }
    while table[i] <> Nil do
    begin
      { Prepare to free the current item }
      pDel := table[i];

      { table[i] is made to point to the next item }
      table[i] := table[i].next;

      { Free the current item }
      pDel.free
    end
  end
end;

end.

