{ Advanced\Graphs - Example program from http://www.SoftwareForEducation.com/ }

{
    Example    A graph plotting program.

    Task       Plot your own graphs.  For example
               y = x
               y = 3 * x
               y = 2 * x - 4
               y = x * x
               y = 10 - 2 * x * x
               y = sin(x)
               y = sin(x) + sin(3 * x) / 3 + sin(5 * x) / 5
}

unit New_f;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    ButtonPrint: TButton;
    procedure PaintBox1Paint(Sender: TObject);
    procedure ButtonPrintClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ Plot a graph of y=x+1 }
procedure TForm1.PaintBox1Paint(Sender: TObject);
var xi, yi           : Integer;   { 123    }
    x,  y            : real;      { 17.223 }
    xScale, yScale   : Real;
    xOffset, yOffset : Real;
    { ===================================================== }
    { Clear the window }
    procedure clearWindow;
    begin
      { Clear the screen by plotting a rectangle. }
      PaintBox1.canvas.pen.color := clBlack;
      PaintBox1.canvas.brush.color := clWhite;
      PaintBox1.canvas.rectangle(0, 0, paintBox1.width, paintBox1.height);
    end;
    { ===================================================== }
    { Vertical grid lines }
    procedure verticalGridLines;
    var i : integer;
    begin
      for i := -5 to 5 do
      begin
        if i = 0 then
          PaintBox1.canvas.pen.width := 3
        else
          PaintBox1.canvas.pen.width := 1;

        PaintBox1.canvas.moveTo(round(  i * xScale + xOffset),
                                round(-10 * yScale + yOffset));
        PaintBox1.canvas.lineTo(round(  i * xScale + xOffset),
                                round( 10 * yScale + yOffset));
        PaintBox1.canvas.textOut(round(i * xScale + xOffset) - 8, 5,
                                 ' ' + intToStr(i) + ' ')
      end;
    end;
    { ===================================================== }
    { Horizontal grid lines }
    procedure horizontalGridLines;
    var i : integer;
    begin
      for i := -10 to 10 do
      begin
        if i = 0 then
          PaintBox1.canvas.pen.width := 3
        else
          PaintBox1.canvas.pen.width := 1;

        PaintBox1.canvas.moveTo(round(-5 * xScale + xOffset),
                                round( i * yScale + yOffset));
        PaintBox1.canvas.lineTo(round( 5 * xScale + xOffset),
                                round( i * yScale + yOffset));
        PaintBox1.canvas.textOut(5, round(i * yScale + yOffset) - 8,
                                 ' ' + intToStr(i) + ' ')
      end;
    end;
    { ===================================================== }
begin
  { Work out the scale factors }
  xScale :=  paintBox1.width / 10;   { 10 graph divisions }
  yScale := -paintBox1.height / 20;  { 20 divisions and upside down }

  { Work out the offsets }
  xOffset := paintBox1.width / 2;    { Centre of the screen }
  yOffset := paintBox1.height / 2;   { Centre of the screen }

  clearWindow;

  { Plot the graph }
  x := -5;                           { x starts at -5  }
  while x <= 5 do                    { x goes up to +5 }
  begin
    y := x * x;                      { Calculate the y value }

    xi := round(x * xScale + xOffset);   { Round off to whole number }
    yi := round(y * yScale + yOffset);   { Round off to whole number }

    PaintBox1.canvas.pixels[xi, yi] := clBlack;  { Plot the point }
    x := x + 0.01;
  end;

  verticalGridLines;
  horizontalGridLines
end;

procedure TForm1.ButtonPrintClick(Sender: TObject);
begin
  Print
end;

end.
